<?php 



if ( Yii::app()->user->branding->product=="HMP100" || Yii::app()->user->branding->product=="HMP130" || Yii::app()->user->branding->product=="HMP200" ){
    echo "<map id='advancedMap' name='advancedMap'>\n";
    
    if ( Yii::app()->user->branding->product=="HMP200" ) {
        echo "<area shape='rect' coords='126,126,146,146'alt='Advanced settings menu' href='#' />\n";
    } else if ( Yii::app()->user->branding->product=="HMP130" ) {
        echo "<area shape='circle' coords='430,155,7'alt='Advanced settings menu' href='#' />\n";
    } else {
        echo "<area shape='circle' coords='433,126,7'alt='Advanced settings menu' href='#' />\n";
    }
    echo "</map>\n";

    $this->widget('HelpBox', array('helpTitle'=>"Advanced settings", 
                                                'helpContent'=>"Warning:<br/>Enabling advanced settings lets you modify parameters that may impact the rendering performance of the unit.<br/>".
                                                                "Do not enable this mode unless explicitly requested to by support.<br/><br/>".
                                                                "Are you sure you want to enable advanced settings ?",
                                                'theme'=>'cupertino',
                                                'icon' => false,
                                                'clickTarget' => 'advancedMap',
                                                'options' => array('width'=>400,
                                                                   'modal'=> true,
                                                                   'height' => 260,
                                                                ),
                                                'callbacks' => array(
                                                                   'buttons' => "{ Yes: function() { window.open('".CHtml::normalizeUrl(array('advanced/enable' ))."','_self'); }, No: function() { $( this ).dialog( 'close' ); } }"
                                                                )
                                    )
                    );
    echo CHtml::image("images/product.jpg", Yii::app()->user->branding->product, array( 'usemap'=>'#advancedMap' ))."\n";
} else {
    echo CHtml::image("images/product.jpg", Yii::app()->user->branding->product )."\n";
}
		
echo CHtml::tag("h2", array(), "Serial Number : " . $serial. " (HW rev. ".$hardware.")")."\n";

echo CHtml::errorSummary( $config )  ."\n";

echo CHtml::openTag("table")."\n";

$str = $info->getFirmware();
if ( $info->isBeta() )
    $str .=" ( beta ".$info->getBuild().")";
echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "Firmware : ").CHtml::tag("td", array(), $str ) )."\n" ;
if (Yii::app()->user->info->model=='Sakura') {
    $txt="";
	if ( $info->getTemp_max() ) {
        $txt = " " . $this->widget('HelpBox', array('helpTitle'=>"Maximum temperature reached", 
                                                'helpContent'=>"The player will shutdown if the condition persists.<br/>".
                                                                "You can increase the shutdown temperature using the ". CHtml::link("maintenance configuration page", array('admin/maintenance', 'tab'=>2)) .".",
                                                'theme'=>'cupertino',
                                                'options' => array('width'=>400) )
                                            , true );
                                               
	}
	if ( $info->getTemp_crit() ) {
		$txt = " " . $this->widget('HelpBox', array('helpTitle'=>"Critical temperature reached", 
                                                'helpContent'=>"The player will shutdown.",
                                                'theme'=>'cupertino'
                                                )
                                            , true );
                                               
		$txt=" warning, critical temperature reached!";
	}
	echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "Temperature : ").CHtml::tag("td", array(), round($info->getTemp(),1) . " &deg;C / ".round($info->getTempF(),1) . " &deg;F".$txt ) )."\n" ;
}
$txt="";
if ( $info->isZeroConf() ){
    $txt = " " . $this->widget('HelpBox', array('helpTitle'=>"Limited network conectivity", 
                                                'helpContent'=>"This device is using a Zeroconf IP address (link-local) and thus it has limited network conectivity.<br/>".
                                                                "Possible causes are: no DHCP server is available or the assigned static IP address is already in use.",
                                                'theme'=>'cupertino',
                                                'options' => array('width'=>400) )
                                               , true );
}
echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "IP : ").CHtml::tag("td", array(), $info->ip ." (".$info->iptype.")".$txt) )   ."\n";
echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "Mac : ").CHtml::tag("td", array(), $info->mac ) ) ."\n";
echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "Device name : ").CHtml::tag("td", array(), htmlspecialchars($name) ) ) ."\n";
echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "Multiscreen ID :  ").CHtml::tag("td", array(), htmlspecialchars($screen) ) ) ."\n";

echo CHtml::closeTag("table")."\n";

if ( $modem->active ) {
    echo CHtml::tag("h2", array(), "3G Modem") ."\n";
    echo CHtml::openTag("table")."\n";
    
    echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "Status : ").CHtml::tag("td", array(), $modem->statusstring ) )."\n" ;
    if ( $modem->signal!==false )
        echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "Signal quality : ").CHtml::tag("td", array(), $modem->signal ) )."\n" ;
    if ( $modem->device!==false )
        echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "Device : ").CHtml::tag("td", array(), $modem->device ) )."\n" ;
    if ( $modem->serial!==false )
        echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "Serial # (IMEI) : ").CHtml::tag("td", array(), $modem->serial ) )."\n" ;
    if ( $modem->subscriber!==false )
        echo CHtml::tag("tr", array(), CHtml::tag("td", array(), "Mobile Subscriber ID : ").CHtml::tag("td", array(), $modem->subscriber ) )."\n" ;
    
    echo CHtml::closeTag("table")."\n";
    
}
echo 	CHtml::form().
		CHtml::activeHiddenField( $wiz, 'active', array( 'value'=>'true') ).
		CHtml::button( "Start Wizard", array('submit'=>array('info/wizard'), 'class' => 'largebutton right' ) ).
		CHtml::endForm();
        
if ( count($usb->devices)>0 ) {
    echo CHtml::tag("h2", array(), "USB Devices") ."\n";
    echo CHtml::openTag("table")."\n";
    foreach ($usb->devices as $device )
        echo CHtml::tag("tr", array(), CHtml::tag("td", array(), $device) )."\n" ;
    
    echo CHtml::closeTag("table")."\n";
}
?>
<script type="text/javascript">//<![CDATA[
$( function() {
	$(".largebutton").button();
});

//]]></script>