<?php 

// checks for the config
echo CHtml::tag("p", array( "class"=>"progress waiting" ), "Checking internet access: " . CHtml::tag("span", array("id"=>"InternetCheck"), "In progress") ) ;
echo CHtml::tag("p", array( "class"=>"progress" , "id"=>"FirmwareCheckMain"), "Checking firmware version: " . CHtml::tag("span", array("id"=>"FirmwareCheck"), "Waiting") ) ;

// could use rpc to trigger the update, or at least we should use AjaX?
$mode = "mode";
echo 	CHtml::tag("div", array("id"=>"UpdateNow", 'class'=>'list-margin' ),
				CHtml::button("Update Now", array('name'=>'update', 
												'class' => 'button', 
												'onclick'=>"StartUpdate()",												
												)
									)
				);
echo	CHtml::tag("div", array("id"=>"UpdatingFirmware", 'class'=>'list-margin'),
				CHtml::tag("p", array(  "class"=>"progress waiting"  ), "Updating firmware: " . CHtml::tag("span", array("id"=>"UpdatingFirmwareStatus"), "Starting") ) 
				);
				
echo	CHtml::tag("div", array("id"=>"Reboot", 'class'=>'list-margin'),
				CHtml::tag("p", array(  "class"=>"progress waiting"  ), "Rebooting Device: " . CHtml::tag("span", array("id"=>"RebootStatus"), "Waiting") ) 
				);

echo $this->renderPartial('wizard/network', array( 'network'=>$network), true );
echo $this->renderPartial('wizard/proxy', array( 'proxy'=>$proxy), true );

$url_net = CHtml::normalizeUrl(array("check/network"));
$url_firm = CHtml::normalizeUrl(array("check/firmware"));
$url_update = CHtml::normalizeUrl(array("check/update"));
$url_status = CHtml::normalizeUrl(array("check/status"));

$url_alive = CHtml::normalizeUrl( "/boot-id" );
$bootID = MaintenanceJobs::bootID();
	
?>
<script type="text/javascript">//<![CDATA[

var update_id = "";
var idx = 0;
function CheckAlive( ) {
	$.ajax({
		url: '<?php echo $url_alive; ?>',
		dataType: 'text',
		success: function( data, status ) {
			if ( $.trim(data)!="" && $.trim(data)!="<?php echo $bootID; ?>" ) {
				$('#RebootStatus').text( "Finished, reloading the page" ).parent()
								  .removeClass("waiting")
								  .addClass("sucess");
				location.reload( true );
			} else {
				$('#RebootStatus').text( "Still waiting" );
				setTimeout( CheckAlive ,10000); 
			}
		},
		error: function() {
			// device is not responding yet, should try again in a few seconds
			$('#RebootStatus').text( "Still waiting" );
			setTimeout( CheckAlive ,10000); 
		}
	});
}

function Status( data ) {
	if ( data.success ) {
		if ( data.running ) {
			setTimeout( StartStatus ,30000);
			$('#UpdatingFirmwareStatus').text( $('#UpdatingFirmwareStatus').text() + "." );
		} else {
			var txt = "Success, updated " + data.type;
			if ( 'version' in data )
				txt += " to version " + data.version;
			$('#UpdatingFirmwareStatus').text( txt ).parent()
										.removeClass("waiting")
										.addClass("sucess");
			
			$('#Reboot').show();
						
			setTimeout( CheckAlive ,120000); // we know this should take aroung 2.0 minutes
		}
	} else {
		$('#UpdatingFirmwareStatus').text("Failed: " + data.reason).parent()
									.removeClass("waiting")
									.addClass("fail");
	}
}
function StartStatus( data ) {
	$.getJSON('<?php echo $url_status; ?>', { id: update_id, idx: idx++ }, Status);
}
function Update( data ) {
	if ( data.success ) {
		update_id = data.id;
		$('#UpdatingFirmwareStatus').text("In progress ");
		setTimeout( StartStatus ,30000);
	} else {
		$('#UpdatingFirmwareStatus').text("Failed: " + data.reason).parent()
									.removeClass("waiting")
									.addClass("fail");
	}
}
function StartUpdate( ) {
    $('#FirmwareCheckMain').hide();
	$('#UpdateNow').hide();
	$('#UpdatingFirmware').show();
	$.getJSON('<?php echo $url_update; ?>', Update);
}

$(function() {
    //$("#UpdateNow").parent().parent().find(".next").attr("value", "Skip" );
    function finish() {
        $("#UpdateNow").parent().parent().find(".next").attr("value", "Next" );
    }
    function CheckIp( data ) {
        if ( data.success ) {
            $('#InternetCheck')	.text("Success").parent()
                                .removeClass("waiting")
                                .addClass("sucess");
            $('#FirmwareCheck') .text("In progress")
                                .parent().addClass("waiting");
            $.getJSON('<?php echo $url_firm; ?>', CheckFirmware);
        } else {
            $('#InternetCheck').text("Failed ("+ data.code + ")").parent()
                                .removeClass("waiting")
                                .addClass("fail");
            $('#FirmwareCheck').text("No internet access");
            if ( data.code==4 || data.code==5 || data.code==6 )
                $('#ProxySettings').show();
            else
                $('#NetworkSettings').show();
            $('#FirmwareInlineStatus').text( "No internet access" );
            $('#FirmwareInlineStatusProgress').removeClass("waiting")
                                    .addClass("fail");
        }
    }
    function CheckFirmware( data ) {
        if ( data.success ) {
            if ( data.updates==0 ) {
                $('#FirmwareCheck').text("Firmware is up to date").parent()
                                    .removeClass("waiting")
                                    .addClass("sucess");
                $('#FirmwareInlineStatus').text("Up to date");
                $('#FirmwareInlineStatusProgress').removeClass("waiting")
                                    .addClass("sucess");
                finish();
            } else {
                var txt = "Need to update " + data.type;
                if ( 'version' in data )
                    txt += " to version " + data.version;
                $('#FirmwareCheck').text( txt ).parent()
                                    .removeClass("waiting")
                                    .addClass("info");
                $('#UpdateNow').show();
                $('#FirmwareInlineStatus').text( txt );
                $('#FirmwareInlineStatusProgress').removeClass("waiting")
                                    .addClass("info");
            }
        } else {
            $('#FirmwareCheck').text("Failed: " + data.reason).parent()
                                .removeClass("waiting")
                                .addClass("fail");
            $('#FirmwareInlineStatus').text( "Checking failed" );
            $('#FirmwareInlineStatusProgress').removeClass("waiting")
                                    .addClass("fail");
            finish();
        }
    }

    $('#UpdateNow').hide();
    $('#ProxySettings').hide();
    $('#NetworkSettings').hide();
    $('#UpdatingFirmware').hide();
    $('#Reboot').hide();
    $.getJSON('<?php echo $url_net; ?>', CheckIp);
});

//]]></script>
