<?php 

$id = rand(0, 1000000);

$timezones = $time->getTimezones();
$arealist = array();
$citylist = array();

$arealist["dummy"] = "Please select an area";

foreach($timezones as $name => $val){
    if ( !isset($activeArea) )
        $activeArea = $val;
	if ( isset($time->tzmap[ $name ]) ){
        $arealist[$name] = $time->tzmap[ $name ];
        if ( $name == $time->tzarea ) 
            $activeArea=$val;
    }
}
if ( !$disabled ) {
    foreach( $activeArea as $name => $path ){
        $citylist[ htmlspecialchars($path) ] = $name;
    }
} else {
    $time->tzarea = "dummy";
    $citylist[ 'dummy' ] = "-------------------";
}

//echo CHtml::tag("h2", array(), "Time Zone") ."\n";

echo CHtml::errorSummary( $time )  ."\n";

echo CHtml::tag("p", array(), "Please select a location that is in the same time zone as the ".Yii::app()->user->branding->product."." );

//echo CHtml::activeLabel($time, "link");
echo CHtml::activeDropDownList($time, "tzarea", $arealist, array('id'=>"RegionSelect$id", 'onchange'=>"selectRegion$id()" ) ) ." ";
echo CHtml::activeDropDownList($time, "link", $citylist, array('id'=>"CitySelect$id") );

// <script type="text/javascript" src="/css/jquery.ui.selectmenu.js"></script>
?>

<script type="text/javascript">//<![CDATA[

var timezonesCity=new Array();
var timezonesUri=new Array();
<?php

$idx = 1;

foreach ($timezones as $name => $val){
	$cities="";
	$uris="";
	if (isset($time->tzmap[$name])){
		foreach ($val as $city => $uri){
			$cities.="\"$city\",";
			$uris.="\"$uri\",";		
		}
		$cities=substr($cities,0,strlen($cities)-1);
		$uris=substr($uris,0,strlen($uris)-1);
	
		echo "timezonesCity[$idx] = new Array( $cities );\n";
		echo "timezonesUri[$idx] = new Array( $uris );\n";
		$idx++;
	}
}
if ( $disabled )
    echo "$('#CitySelect$id').hide();\n";
?>

//$('#RegionSelect<?php echo $id;?>').selectmenu();

function selectRegion<?php echo $id;?>()
{
    var selectRegion=document.getElementById("RegionSelect<?php echo $id;?>");
    var selectCity=document.getElementById("CitySelect<?php echo $id;?>");
    var reg=selectRegion.selectedIndex;
    if ( reg==0 ) {
        $(selectCity).hide();
        return;
    }
    $(selectCity).show();
    var nbCity=selectCity.length;
    for (var i=0; i<nbCity; i++){
        selectCity.remove(0);
    }
    nbCity=timezonesCity[reg].length;
    for (var i=0; i<nbCity; i++){
        var newOption=new Option;
        newOption.text=timezonesCity[reg][i];
        newOption.value=timezonesUri[reg][i];
        try {
            selectCity.add(newOption, null);
        }catch(ex) {
            selectCity.add(newOption);
        }
    }
}

//]]></script>
