<?php 

//hack to make sure teh jQueryUI is corectly imported
$this->widget('WizardItems', array( 'theme'=>'cupertino' ) );

$reload = Yii::app()->user->tools->reboot==2?1:0;;

if ( Yii::app()->user->tools->reboot==3 ){
    echo CHtml::tag("h1", array(), "Shutdown") ."\n";
	echo CHtml::tag("p", array( 'id'=>'RebootStatus' ), "The ".Yii::app()->user->branding->product." is now shutting down." ) ."\n";
} else {
    echo CHtml::tag("h1", array(), "Restarting") ."\n";
	echo CHtml::tag("p", array( 'id'=>'RebootStatus' ), "The ".Yii::app()->user->branding->product." is now restarting." ) ."\n";
}

foreach ( $messages as $message ){
    echo $message;
}

if ( isset( $wizard ) && $wizard ) {
    if ( $fusion ) {
        $reload = 1;
        $msg = "You will automatically be redirected to " . CHtml::link( "Fusion", $redirect ) .".";
    } else {
        $msg = CHtml::tag("div", array( 'class'=>'action') , CHtml::button("OK", array( 'class' => 'button', 'id'=>'Reload' ) ) );
    }
} else {
    echo CHtml::tag("p", array(),  "Reason: $reason") . "\n";
    $msg = CHtml::tag("div", array( 'class'=>'action') , CHtml::button("OK", array( 'class' => 'button', 'id'=>'Reload' ) ) );
}

if ( Yii::app()->user->tools->reboot==3) {
    echo CHtml::tag("p",array(),   "When finished, you can safely unplug it from the power"). "\n";
} elseif ( Yii::app()->user->tools->reboot==1 ) {
    
    if ( !isset($redirect) || $redirect===false )
        $redirect = array();
    echo CHtml::tag("p",array( 'id'=>'Rebooting' ),   "Please wait for the device to restart.") . "\n";
    
    echo CHtml::tag("div",array( 'id'=>'Rebooted' ), $msg ) . "\n";

} elseif ( Yii::app()->user->tools->reboot==2 ) {
    echo CHtml::tag("h2", array(), "Diagnostic Mode") ."\n";
    echo "<br/><p>The system will reboot in diagnostic (i.e., recovery) mode: ";
    $state = Yii::app()->user->tools->checkRecoverySate();
    if ( $state == "bonjour" ) {
		$inf = new BasicInfo;
		$redirect = "http://".$inf->hostname.".local/";	
        echo "the unit is always reachable at <a href='http://".$inf->hostname.".local/'>http://".$inf->hostname.".local</a> from Zeroconf enabled computers on the local network.</p>";
        echo CHtml::tag("p", array(),  "Please use the <a href='http://".$inf->hostname.".local/'>following link</a> to refresh the interface."). "\n";
    } elseif ( $state == "current" ) {
		$redirect = "/";
        echo "the network address should be the same as the one currently.</p>";
        echo CHtml::tag("p", array(),  "Please use the <a href='/'>following link</a> to refresh the interface."). "\n";
    }else{
		$redirect = "http://192.168.1.11/";
        echo "the network address will be in the range 192.168.1.11 to 192.168.1.29.</p>";
        echo "<p>Please use one of the following link to refresh the interface: ";
        echo "<a href='http://192.168.1.11/'>http://192.168.1.11/</a>, <a href='http://192.168.1.12/'>http://192.168.1.12/</a>, <a href='http://192.168.1.13/'>http://192.168.1.13/</a> and so on.</p>\n";
    }
}
if ( Yii::app()->user->tools->reboot!=3) {
	$url_alive = CHtml::normalizeUrl( "/boot-id" );
	$url_redirect = CHtml::normalizeUrl( $redirect );
	$bootID = MaintenanceJobs::bootID();
?>

<script type="text/javascript">//<![CDATA[

function redirectPage() {
    location.assign( '<?php echo $url_redirect; ?>' );
}
$( function() {
	// hide all
    $('#Rebooted').hide();
    $(".button").button();
    $("#Reload").click( redirectPage );
});
var reload = <?php echo $reload; ?>;

function CheckAlive( ) {
    $.ajax({
		url: '<?php echo $url_alive; ?>',
		dataType: 'text',
		success: function( data ) {
			if ( $.trim(data)!="" && $.trim(data)!="<?php echo $bootID; ?>" ) {
				if ( reload ) {
				    $('#RebootStatus').text( "Device has restarted, reloading the page" );
				    setTimeout( redirectPage, 2000); 
				} else {
				    $('#RebootStatus').text( "Configuration has been applied successfully." );
				    $('#Rebooted').show();
				    $('#Rebooting').hide();
				}
			} else {
				// device did not reboot yet, or is rebooting 
				setTimeout( CheckAlive ,10000); 
			}
		},
		error: function( obj, status, error ) {
            if ( obj.status==404 ) {
                if ( reload ) {
                    $('#RebootStatus').text( "Device restarted, going to recovery console" );
                    setTimeout( redirectPage, 2000);
                } else {
                    $('#RebootStatus').text( "Configuration has been applied successfully." );
                    $('#Rebooted').show();
                    $('#Rebooting').hide();
                } 
			} else {
				// device is not responding yet, should try again in a few seconds
				$('#RebootStatus').text( "Device is restarting, still waiting" );
				setTimeout( CheckAlive ,10000); 
			}
		}
	});
}
setTimeout( CheckAlive ,60000); // we know this should take more than 1 minute

//]]>
//]]></script>
<?php 
}