<?php

if ( ! extension_loaded('json') && dl('json.so') !== TRUE ) {
     echo "ERROR: cannot load json\n";
     trigger_error("Failed loading json extension", E_USER_ERROR);
}

// set PHP timezone from setings
$realpath = readlink( "/etc/localtime" );
if ( substr( $realpath,0,1 )!='/' )
    $realpath = realpath( "/etc/" . $realpath );
$pos = strpos( $realpath, "zoneinfo/");
if ( $pos!==false ) {
    $link = substr($realpath, strpos( $realpath, "zoneinfo/")+9);
    date_default_timezone_set( $link );
}
$vendor = "[undefined]";
        
require_once './protected/utils/JSONRPCServer.php';
require_once './protected/utils/WebStorageAPI.php';
require_once './protected/utils/PullMode.php';

require_once './protected/utils/Updater.php'; // for the update process
require_once './protected/utils/MaintenanceJobs.php'; // for the reboot and other processes
require_once './protected/utils/SecurityJobs.php'; // for the security settings

require_once './protected/utils/MainInfo.php'; // for the info

require_once "/usr/share/resources/default/interface/branding.php"; // branding info


if ( $vendor!="SpinetiX" ) {
    header("HTTP/1.0 404 Not Found");
?>
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<html><head>
<title>404 Not Found</title>
</head><body>
<h1>Not Found</h1>
<p>The requested URL <?php echo $_SERVER['REQUEST_URI'];?> was not found on this server.</p>
</body></html>

<?php
    exit(0);
}


class RPC {
    public $needreload = false;
    /**
      * @var array Additinal users autorized for a specific method
      */
    public $methods_users = array(
        'get_info' => array( 'monitoring' ),
        'get_config' => array( 'monitoring' ),
        'webstorage_list' => array( 'content' ),
        'webstorage_get' => array( 'content' ),
        'webstorage_set' => array( 'content' ),
        'webstorage_remove' => array( 'content' ),
        'webstorage_cmpxchg' => array( 'content' ),
    ); 
/*
	restart
	
	void restart();
	
	Immediately initiates a clean restart of the device. If a restart has already been initiated the call is ignored.
*/
	public function restart() {
        $result = array();
		$jobs = new MaintenanceJobs;
		
		$ret = $jobs->shutdown("user initiated shutdown : rpc restart() call", false, 1);
		
        $result['success'] = ($ret === TRUE);
        $result['reason'] = ($ret === TRUE ? '' : $ret);
		
		return $result;
	}
	
	public function shutdown() {
        $result = array();
		$jobs = new MaintenanceJobs;
		
		$ret = $jobs->shutdown("user initiated shutdown with power-off : rpc shutdown() call", false, 1, true);

        $result['success'] = ($ret === TRUE);
        $result['reason'] = ($ret === TRUE ? '' : $ret);
		
		return $result;
	}
	
	public function get_info( $options=array() ) {
        $serial = "[undefined]";
        $model = "[undefined]";
        $hardware = "[undefined]";
        $firmware = "[undefined]";
        $build = "[undefined]";
        if ( !is_array( $options ) ) {
            $options=array();
        }
		$result = array();
		getInfoSerial( $serial, $model, $hardware );
		$result['serial'] = $serial;
		//$result['version'] = $hardware;

		// name
		$conf = new DOMDocument;
		if ( $conf->load('/etc/raperca/spxconfig.xml') ) {
		   $xp = new DOMXPath($conf);
		   $xp->registerNamespace('d', 'http://www.spinetix.com/namespace/1.0/spxconf');
		   $nl = $xp->query("//d:player/d:reporting/@deviceName");
		   if ($nl->length) {
			$result['name'] = $nl->item(0)->value;
		   }
		}
		if ( ! isset($result['name']) || empty($result['name']) )
		   $result['name'] = $result['serial'];

		// model
		$result['model'] = getInfoModel();
		// running mode
		$result['mode'] = getInfoSafeMode() ? 'safe' : 'normal';


		// firmware
		$result['firmware'] = array();
		// firmware - version
		getInfoFirmware( $firmware, $build );
		$result['firmware']['version'] = $firmware . "-" . $build;
		// firmware - status
		$result['firmware']['status'] = getInfoFirmwareCorrupted()?'corrupted':'normal';
        
        $result['uptime'] = getInfoUpTime();
        $result['bootid'] = MaintenanceJobs::bootID();

        $parser = new ParseLogs();
        
        if ( $model=="Sakura" && isset($options['temperature']) && $options['temperature'] !== false ) {
            // temperature
            $t = getInfoTemperature();
            $result['temperature']['C'] = $t['temp'];
            $result['temperature']['F'] = (9/5)*$t['temp']+32;
            if ( $t['crit'] )
                $result['temperature']['alarm'] = 'critical';
            else if ( $t['max'] )
                $result['temperature']['alarm'] = 'maximum';
            else
                $result['temperature']['alarm'] = 'none';
            
            if ( $options['temperature'] !== true ){
                $result['temperature']['history'] = $parser->readTemperature( $options['temperature'] );
            }
        }
        if ( isset($options['display']) && $options['display'] ) {
            // display
            $screeninfo = new ScreenInfoBasics();
            $screeninfo->load();
            $result['display'] = array();
            foreach( $screeninfo->monitors as $screen ){
                $info = array(
                    'type' => $screen['type'] 
                );
                if ( isset( $screen['powered'] ) )
                    $info['power'] = $screen['powered'];
                else
                    $info['power'] = 'gone';
                $result['display'][] = $info;   
            }
        }
        if ( isset($options['storage']) && $options['storage'] ) {
            // storage
            $result['storage'] = array();
            $infoSystem = getDiskInfo( "/" );
            $infoSystem['type'] = 'system';
            $result['storage'][] = $infoSystem;
            
            $infoContent = getDiskInfo( "/srv/raperca/content" );
            $infoContent['type'] = 'content';
            $result['storage'][] = $infoContent;
        }
        
        
        if ( isset($options['stats']) && $options['stats']!==false ) {
            $result['stats'] = $parser->readStats( $options['stats'] );
            
        }
        if ( isset($options['errors']) && $options['errors']!==false ) {
            $result['errors'] = $parser->readErrors( $options['errors'] );
        }
        if ( isset($options['reason']) && $options['reason']!==false ) {
            $result['reason'] = ParseSyslog::getRebootReason();
        }
		return $result;
	}
	 
	
/*
	firmware_update
	
	string handle firmware_update(object options);
	
	Starts the firmware update process in the background. 
	A handle is returned that should be used to poll for completion using the firmware_update_status() call.
	object options {
		"repo_id"	: [ string .. ],					// optional
		"repo_uri"	: [ { "id" : string, "uri" : string } ... ],	// optional
		"max_wait"	: int,							// optional
		"check_only"	: bool,						// optional
	};
	repo_id	
		an array specifying the repository to use for updating, currently only one can be specified; this argument is optional, 
		if not present the configured default is used. The recognized repository IDs are "base" and "local-usb".
	repo_uri	
		an array of pairs of repository IDs and URIs, used to override the URI of a repository without requiring a configuration change; 
		this argument is optional, if not present the configured default is used. The URIs must be percent encoded as specified in RFC 3986. 
		Only http, https and local file URI schemes are supported.
	max_wait	
		the maximum wait, in seconds, before the updates server is contacted, the actual wait is a random time between 0 and the maximum; 
		this argument is optional, if not present the default of 600 seconds is used. 
		The purpose of this argument is to reduce load on servers, a value of 0 disables the wait.
	check_only	
		if true only a check is performed against the updates server, no updates are downloaded nor applied; 
		defaults to false if not present.
	handle	
		an opaque string which should be passed to firmware_update_status() to poll for completion.
	
	Note: performing a check is resource intensive as all firmware components are evaluated, 
		  therefore this call should not be made frequently or the player performance of the HMP may be degraded.
*/
    public function firmware_update( $options=array() ) {
        global $product;
        global $email;
        
		$updater = new Updater;
		$updater->product = $product;
		$updater->email = $email;
		
		$source = 'default';
		$id = "";
		if (isset($options['repo_id']) && isset($options['repo_id'][0]) )
			$id = $options['repo_id'][0];
		if ( $id== "local-usb") 
			$source = "usb";
		if (isset($options['repo_uri']) && is_array($options['repo_uri']) ){
			foreach ($options['repo_uri'] as $repo) {
				if ( $repo['id']==$id )
					$source = $repo['uri'];
			}
		}
		
		$max_wait=-1;
		if ( isset($options['max_wait']) )
			$max_wait = (int)$options['max_wait'];
		
		$check_only=false;
		if ( isset($options['check_only']) && $options['check_only']=='true' )
			$check_only=true;
        
        $test=false;
		if ( isset($options['test']) && $options['test']=='true' )
			$test=true;
		if ( $updater->startUpdate( $check_only, $source, $max_wait, false, $test ) ){
			return $updater->update_id;
		} else {
			throw new Exception($updater->errorStr);
		}
    }
     
/*
	firmware_update_status
	
	object status firmware_update_status(string handle, object options);
	
	Returns the status of a previously started firmware update. 
	When a firmware update is complete further calls to this method with the same handle will return an error.
	
	object options {
		"include_log"	: string,	// optional
	};
	
	object status {
		"exit"		: string,
		"mode"		: string,
		"type"		: string,
		"version"	: string,
		"packages"	: int,
		"complete"	: bool,
		"done"		: bool,
		"log"		: string,
	};
	handle	
		the opaque string returned by the firmware_update() call, used to identify the call for which the call is done.
	
	include_log	
		specifies if the message log should be included in the response; 
		it should be one of 
			"no" (do not send log, default), 
			"yes" (send it), 
			"on_done" (send it only when done is true, i.e. at the end of the run); 
		if not present "no" is assumed.
	
	exit	
		the exit status of the update process, one of 
			"ok" (completed without error), 
			"error" (an error occurred that prevented the update), 
			"fatal" (a fatal error occurred that left the firmware corrupted); 
		only present when done is true.
	mode	
		the running mode, one of 
			"check" (only checking for updates), 
			"update" (updating), 
			"test" (testing updates, for debugging only); 
		not present if not yet known. 
	type	
		the type of update available or being done, one of 
			"firmware" (new firmware), 
			"updater" (firmware updater component only), 
			"minor" (only minor components) or 
			"none" (if no updates available); 
		not present if not yet known.
	version	
		the version of the firmware that is available, if type is "firmware", 
		or version of updater component that is available, if type is "updater"; 
		not present if not applicable.
	packages	
		the number of packages available or being updated; 
		not present if not yet known.
	complete	
		true if the update process will be complete when done, 
		false if the update process should be restarted to get a complete update 
		(e.g., the updater needed to be updated before the complete firmware); 
		not present if not yet known.
	done	
		if true the firmware_update() call is done, no further calls to this method can be done with this handle.
	log	
		the complete message log of the firmware update process; not present if not requested.
	
	Note: when a firmware update is successfully completed the HMP automatically restarts, so it will be unreachable until it restarts; 
		  there is however, a 1 minute delay between the end of the firmware update and the start of the shutdown procedure.
*/
	public function firmware_update_status($handle="", $options=array() ) {
		if (empty($handle))
			throw new Exception("Missing handle");
		$updater = new Updater;
		
		
		$logs = $updater->getLog( $handle );
		if ( $logs===false )
			throw new Exception("Updater not running");
		
		$updater->parseLog( $logs );
		$result = array();
		$done = false;
		if ( !$updater->isUpdateRunning( ) ){
			$done = true;
			if ( $updater->updater_status===false ){
				// update not running but log is not complete
				$status = $updater->getStatus();
				if ( $status=="READY"	)
					$result['exit'] = 'ok';
				elseif ( $status=="CORRUPTED" )
					$result['exit'] = 'fatal';
				else
					$result['exit'] = 'error';
			} else {
				if ( $updater->updater_status=="OK")
					$result['exit'] = 'ok';
				else
					$result['exit'] = 'error';
			}
			$updater->cleanUp( $handle );
		}
		
		if ( $updater->updater_mode!==false ){
			$result['mode'] = $updater->updater_mode;
		}
		if ( $updater->update_info!==false ){
			if ($updater->update_info['type']=="FIRMWARE")
				$result['type'] = "firmware";
			elseif ($updater->update_info['type']=="UPDATER")
				$result['type'] = "updater";
			elseif ( $updater->nb_updates!=0 )
				$result['type'] = "minor";
			else
				$result['type'] = "none";
			$result['version'] = $updater->update_info['ver']."-".$updater->update_info['rel'];
		}
		if ( $updater->nb_updates!==false ){
			$result['packages'] = intval( $updater->nb_updates );
			if ( $updater->nb_updates==0 )
				$result['type'] = "none";
            else if ( $done && !isset($result['type']) )
                $result['type'] = "minor";
		}
		if ( $done ){
			$result['complete'] = $updater->updater_fallback?false:true;
		}
		
		$include_log = false;
		if (isset($options['include_log'])) {
			if ($done && $options['include_log'] == 'on_done')
				$include_log = true;
			elseif ($options['include_log'] == 'yes')
				$include_log = true;
		}
		
		$result['done'] = $done;
		if ($include_log)
			$result['log'] = implode( "\n", $logs );
		return $result;
	}
	/* set_password
    
    void set_password(object pwinfo);

    Removes or sets a new password for a user on the HMP. Passwords can be set by sending them in clear or by sending the digest.
    Note that setting a password for users others than admin and setting no password for admin offers no protection as the passwords 
    can be changed by anyone having network access to the HMP.
    object pwinfo {
        "type"		: string,
        "user"		: string,
        "realm"	: [ string ...],	// only for type digest
        "password"	: [ string ...],	// only for type other than none
    };
    type	
        The type of password, either none (removes password for user), cleartext (new password sent in clear) or digest (password digest sent for each realm).
    user	
        The user for which to set the new password, either admin, content or monitoring.
    realm	
        The realms used to encode the password digests; only used for type digest. The realms to be used for each user are specified below.
    password	
        For type cleartext this array should contain a single element, which is the new password in clear. 
        For type digest it should be the array of digests of the password obtained for each realm.
    */
	public function set_password( $pwinfo=null ) {
        if ( $pwinfo===null )
			throw new Exception("Missing pwinfo");
        
        if ( !isset($pwinfo['type']) )
			throw new Exception("Type is required");
	    
        if ( !isset($pwinfo['user']) || ( $pwinfo['user']!='admin' && $pwinfo['user']!='content' && $pwinfo['user']!='monitoring' ) )
            throw new Exception("user must be one of the following: admin, content or monitoring");
        
        if ( Updater::isUpdateInProgress() )
            throw new Exception("Firmware update in progress");
            
        $job = new SecurityJobs;
        
        switch ( $pwinfo['type'] ) {
            case 'none':
                // clearing the user 
                if ( $job->isProtected($pwinfo['user'] ) ){
                    $ret = $job->clearAccess( $pwinfo['user'] );
                    if ( $ret!==true )
                        throw new Exception( $ret );
                }
            break;
            case 'cleartext':
            case 'digest':
                // adding an user
                if ( !isset($pwinfo['password']) || !is_array($pwinfo['password']) )
                    throw new Exception("password array should contain the new password");
                if ( $pwinfo['type']=="digest" 
                     && ( !isset($pwinfo['realm']) || !is_array($pwinfo['realm']) || count($pwinfo['password'])!=count($pwinfo['realm']) )
					)
                    throw new Exception("realm array should contain the new realm");
                if ( $pwinfo['type']=="digest"){
                    foreach ($job->spxpass_mendatory_realm[$pwinfo['user']] as $realm) {
                        if ( !in_array($realm, $pwinfo['realm']) )
                            throw new Exception("the required realm is missing");
                    }
                }
                $users = $job->getUsers( );
                $job->clearUser( $users, $pwinfo['user'] );
                foreach ( $pwinfo['password'] as $idx=>$pass ) {
                    if ( $pwinfo['type']=="cleartext" )
                        foreach( $job->spxpass_realm[$pwinfo['user']] as $realm )
                            $job->addUser($users, $pwinfo['user'], $realm, $pwinfo['password'][0]);    
                    else 
                        $job->addUser($users, $pwinfo['user'], $pwinfo['realm'][$idx], $pass, true);
                }
                $ret = $job->saveUsers( $users );
                if ( $ret!==true )
                    throw new Exception( $ret );
                        
                if ( !$job->isProtected($pwinfo['user'] ) ){
                    $ret = $job->setAccess( $pwinfo['user'] );
                    if ( $ret!==true )
                        throw new Exception( $ret );
                }
            break;
            default:
                throw new Exception("Type must be one of the following: none, cleartext or digest");
        }
        
        $this->needreload = $job->needreload;
    }
    
    public function set_config( $config=null ) {
        if ( $config===null )
			throw new Exception("Missing config");
        
        if ( !isset($config['xmlconfig']) || $config['xmlconfig']=="" )
			throw new Exception("xmlconfig is required");
        
        if ( Updater::isUpdateInProgress() )
            throw new Exception("Firmware update in progress");
        
        if(PHP_OS == "WINNT"){
            $yii=dirname(__FILE__).'/../../../framework/yii.php'; // for debugging
            defined('YII_DEBUG') or define('YII_DEBUG',true);
        } else
            $yii='yii-framework/yii.php';
        $conf=dirname(__FILE__).'/protected/config/main.php';
        require_once($yii);
        Yii::createWebApplication($conf);
                
        $result = array();
        $backup = new ConfigBackup;
        $backup->apply( $config['xmlconfig'] );
        
        
        
        if ( $backup->hasErrors() ) {
            $errs = array();
            foreach ($backup->getErrors() as $attr=>$desc ) {
                if ( is_array($desc) ){
                    foreach ($desc as $d ) {
                        $errs[] = array('element'=>$attr, 'description'=>$d );
                    } 
                } else {
                    $errs[] = array('element'=>$attr, 'description'=>$desc );
                }
            }
            $result['errors'] = $errs;
        }
        
        $backup->reloadConfig();
        
        $result['success'] = !$backup->hasErrors();
        $result['reboot_pending'] = Yii::app()->user->status->installationmode;
        $result['reboot'] = Yii::app()->user->tools->doShutdown() && !Yii::app()->user->status->installationmode;
        if ( Yii::app()->user->tools->doShutdown() ) 
            Yii::app()->user->tools->shutdown( false, false, 1 );
        else 
            $this->needreload = $backup->needreload;
        return $result;
        
    }
    
    public function get_config(  ) {
    
        if(PHP_OS == "WINNT"){
            $yii=dirname(__FILE__).'/../../../framework/yii.php'; // for debugging
            defined('YII_DEBUG') or define('YII_DEBUG',true);
        } else
            $yii='yii-framework/yii.php';
        $config=dirname(__FILE__).'/protected/config/main.php';
        require_once($yii);
        // Create the application, so that all setup are initialized. It might be possible to initialize only a subset of component by doing init one by one
        Yii::createWebApplication($config);
        
        //Yii::setPathOfAlias('application', dirname(__FILE__).DIRECTORY_SEPARATOR.'protected' );
        //Yii::import('application.models.*');
        // Need users
        
        $backup = new ConfigBackup;
        
        $result = array();
        
        $config = $backup->create();
        $result['xmlconfig'] = $config;
        
        return $result;
        
    }
    
    public function add_pull_action( $action=null ) {
        if ( $action===null )
			throw new Exception("Missing action");
        
        if ( !isset($action['type']) )
			throw new Exception("type is required");
        
        if ( !isset($action['uri']) )
			throw new Exception("uri is required");
        
        
        if ( $action['type']!="publish" && $action['type']!="upload" && $action['type']!="rpc" )
			throw new Exception("type must be one of the following: publish or upload");
        
        if ( !isset($action['max_retry']) )
            $action['max_retry'] = 3600;
        
        $pull = new PullMode();
        return $pull->createEvent( $action['type'], $action['uri'], 
                                   $action['max_retry'], 
                                   isset($action['options'])?$action['options']:null );
    }
    
    public function webstorage_list() {
        
        $store = new WebStorageAPI();

        $ret = $store->getList();
        
        if ( $ret===false )
            throw new Exception("Internal error");
        
        $store->close();
        return $ret;
    }
    public function webstorage_get( $names=null ) {
        if ( $names===null )
			throw new Exception("Missing names");
        
        if ( isset($names['debug']) ){
            $names = $names['debug'];
        }
        $store = new WebStorageAPI();
        $ret = array();
        foreach ( $names as $name ){
            $val = $store->get( $name );
            if ( $val===false )
                throw new Exception("Internal error");            
            $ret[] = $val;
        }
        $store->close();
        return $ret;
    }
    public function webstorage_set( $variables=null ) {
        if ( $variables===null )
			throw new Exception("Missing variables");
        
        if ( isset($variables['debug']) ){
            $variables = $variables['debug'];
        }
        if ( !is_array($variables) || isset($variables['name']) )
            throw new Exception("expect array as argument");
        foreach ( $variables as $variable ){
            if ( !isset($variable['name']) ){
                throw new Exception("name is required");
            }
            if ( !isset($variable['value']) ){
                throw new Exception("value is required");
            }
        }
        $store = new WebStorageAPI();
        $ret = array();
        foreach ( $variables as $variable ){
            $timestamp = "+0";
            if ( isset($variable['offset']) )
                 $timestamp = "+".$variable['offset'];
            if ( isset($variable['timestamp']) )
                 $timestamp = $variable['timestamp'];
            $val = $store->set( $variable['name'], $variable['value'], 
                                $timestamp );
            if ( $val===false ){
                $store->close();
                throw new Exception("Internal error");            
            }
            $ret[] = $val;
        }
        $store->close();
        return $ret;
    }
    public function webstorage_remove( $names=null ) {
        if ( $names===null )
			throw new Exception("Missing names");
        
        if ( isset($names['debug']) ){
            $names = $names['debug'];
        }
        $store = new WebStorageAPI();
        $ret = array();
        foreach ( $names as $name ){
            $val = $store->remove( $name );
            if ( $val===false )
                throw new Exception("Internal error");            
            $ret[] = $val;
        }
        $store->close();
        return $ret;
    }
    public function webstorage_cmpxchg( $variables=null ) {
        if ( $variables===null )
			throw new Exception("Missing variables");
        
        if ( isset($variables['debug']) ){
            $variables = $variables['debug'];
        }
        if ( !is_array($variables) || isset($variables['name']) )
            throw new Exception("expect array as argument");
        foreach ( $variables as $variable ){
            if ( !isset($variable['name']) )
                throw new Exception("name is required");
            if ( !isset($variable['value']) )
                throw new Exception("value is required");
        }
        $store = new WebStorageAPI();
        $ret = array();
        foreach ( $variables as $variable ){
            $timestamp = "+0";
            if ( isset($variable['offset']) )
                 $timestamp = "+".$variable['offset'];
            if ( isset($variable['timestamp']) )
                 $timestamp = $variable['timestamp'];
            
            if ( !isset($variable['expect']) ){
                $val = $store->create( $variable['name'], $variable['value'], 
                                $timestamp );            
            } else {
                $val = $store->cmpxchg( 
                            $variable['name'],
                            $variable['expect'],
                            $variable['value'], 
                            $timestamp 
                    );
            }
            if ( $val===false )
                throw new Exception("Internal error");            
            $ret[] = $val;
        }
        $store->close();
        return $ret;
    }
}

$obj = new RPC( );
$rpc = new JSONRPCServer( $obj );

if ($rpc->run()!==null) {
    if ( $obj->needreload ) {
        # Push everything to http server before reloading the server's config
        ob_flush();
        flush();
        # This must be at the very end, otherwise apache graceful restart
        # may still close the connection to the FastCGI server process running
        # this script.
        exec('/etc/init.d/apache reload < /dev/null > /dev/null 2> /dev/null &');
    }
    exit(0);
}
header("HTTP/1.0 400 Bad Request");
header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<title>Invalid RPC call</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
</head>
<body>
<h1>Invalid RPC call</h1>
<p>This is a JSON-RPC server, only the <?php echo htmlspecialchars(JSONRPCServer::CONTENT_TYPE) ?> 
content-type
is accepted via the POST method with properly formed JSON-RPC 1.0 requests.</p>
</body>
</html>
