#!/bin/sh
#
# License: Copyright 2011 SpinetiX S.A. This file is licensed
#          under the terms of the GNU General Public License version 2.
#          This program is licensed "as is" without any warranty of any
#          kind, whether express or implied.
#
# Copyright 1999-2003 MontaVista Software, Inc.
# Copyright 2002, 2003, 2004 Sony Corporation
# Copyright 2002, 2003, 2004 Matsushita Electric Industrial Co., Ltd.
#
### BEGIN INIT INFO
# Required-Start:
# Required-Stop:
# Should-Start:
# Should-Stop:
# Default-Start: S
# Default-Stop: 0 1 2 3 4 5 6
# Short-Description: Config reset mechanism.
# Description: Config reset mechanism.
### END INIT INFO
# chkconfig: S 36 0

# Init script information
INIT_NAME=config
DESC=""

# The file that permanently stores configuration changes so as to be
# robust against reboots while resetting.
BOOTCONFIG=/boot-config

# The splash resources directory
RCDIR_SPLASH=/usr/share/resources/default/splash

# The file used to flag if the recovery console splash has been set
RECOVERY_SPLASH_SET=/var/lib/spinetix/recovery-splash-set

do_config_changes() {
        config="$(sed -e 's/.*\bconfig=\([^[:space:]]\+\).*/\1/p;d' < /proc/cmdline)"
	if [ -n "$config" ]; then
	    # append boot command line config to overall config orders atomically
	    if [ -f "$BOOTCONFIG" -a -s "$BOOTCONFIG" ]; then
		cat "$BOOTCONFIG" > "$BOOTCONFIG".new && \
		    echo "$config" >> "$BOOTCONFIG".new && \
		    mv -f "$BOOTCONFIG".new "$BOOTCONFIG" && sync
		[ $? -eq 0 ] || \
		    echo "Failed adding configuration request '$config' to '$BOOTCONFIG'" >&2
	    else
		echo "$config" > "$BOOTCONFIG".new && \
		    mv -f "$BOOTCONFIG".new "$BOOTCONFIG" && sync
		[ $? -eq 0 ] || \
		    echo "Failed saving configuration request '$config' to '$BOOTCONFIG'" >&2
	    fi
	elif [ ! -f "$BOOTCONFIG" ]; then
	    # not a regular file or does not exist
	    [ -e "$BOOTCONFIG" ] && rm -f "$BOOTCONFIG"
	    return 0
	elif [ ! -s "$BOOTCONFIG" ]; then
	    # file exists but empty
	    rm -f "$BOOTCONFIG"
	    return 0
	fi
	[ -e "$BOOTCONFIG".new ] && rm -f "$BOOTCONFIG".new

        # NOTE: the list of supported configuration tags must be entered in
        # /etc/spinetix/boot-config-tags.
	while read config; do
	    case "$config" in
		format|format=*)
		    # format is handled earlier in another boot script
		    # but need to keep the tag
		    echo "$config" >> "$BOOTCONFIG".new
		    ;;
		reset)
		    echo '!!!! RESETTING CONFIGURATION !!!!'
		    for f in /etc/spinetix/config.d/*; do
			echo DOING "$(basename $f)"
			$f reset
		    done
		    echo 'DONE'
		    ;;
		dhcp-nfs)
		    echo -n "Resetting network configuration to DHCP with NFS"
		    /etc/spinetix/spxsysconf dhcp
		    echo "."
		    ;;
		dhcp|static=*)
		    echo -n "Resetting network configuration to '$config'"
		    /etc/spinetix/spxsysconf net "$config"
		    echo "."
		    ;;
		*)
		    echo "Ignoring unknown config order $config" >&2
		    ;;
	    esac
	done < "$BOOTCONFIG"

	rm -f "$BOOTCONFIG"
	[ ! -s "$BOOTCONFIG".new ] || mv -f "$BOOTCONFIG".new "$BOOTCONFIG"
	[ $? -eq 0 ] || \
		echo "Failed keeping unhandled configuration requests" >&2
	[ -e "$BOOTCONFIG".new ] && rm -f "$BOOTCONFIG".new
	sync

}

case "$1" in
    start)
	# First process all config changes
	do_config_changes

	# Run the recovery console splash screen update
	if [ ! -f "$RECOVERY_SPLASH_SET" ] && \
	    [ -f "$RCDIR_SPLASH"/recovery.png ] && \
	    [ -f "$RCDIR_SPLASH"/recovery-shutdown.png ]; then
	    failsafe-data \
		remove start.jpg \
		remove shutdown.jpg \
		copy start.png "$RCDIR_SPLASH"/recovery.png \
		copy shutdown.png "$RCDIR_SPLASH"/recovery-shutdown.png
	    touch "$RECOVERY_SPLASH_SET"
	fi

    ;;
    stop)
    ;;
esac
