#! /bin/sh
#
# Name: rootsize.sh
# Author: SpinetiX S.A.
# Copyright: 2012 SpinetiX S.A.
# License: 2008 (c) SpinetiX S.A. This file is licensed
#          under the terms of the GNU General Public License version 2.
#          This program is licensed "as is" without any warranty of any
#          kind, whether express or implied.
#
# Copyright 1999-2003 MontaVista Software, Inc.
# Copyright 2002, 2003, 2004 Sony Corporation
# Copyright 2002, 2003, 2004 Matsushita Electric Industrial Co., Ltd.
#
### BEGIN INIT INFO
# Required-Start:
# Required-Stop:
# Should-Start:
# Should-Stop:
# Default-Start:
# Default-Stop:
# Short-Description: checks root fs free size
# Description: checks root fs free size and cleans files if necessary
### END INIT INFO
# chkconfig: S 15 0

# NOTE: this should run as early as possible after root fs has been
# mounted rw and before other real filesystems are mounted

# Init script information
INIT_NAME=rootsize
DESC="root filesystem free size check"

# Source the init script functions
. /etc/init.d/init-functions

# Source spxsysconf functions
. /etc/spinetix/init-functions

start() {
    local dir

    # Currently /var/run, /var/lock, /var/log, /var/cache and /var/tmp
    # are all in another partition (bind mounts from /srv), so they should be
    # empty except for some base files which cleanvarpath knows of; exception
    # is on upgrades where they may have not been moved yet but then they are
    # not in fstab
    for dir in /var/run /var/lock /var/log /var/cache /var/tmp ; do
	isinfstab "$dir" || continue
	if ! ismounted "$dir" ; then
	    cleanvarpath "$dir"
	else
	    echo "$dir is already mounted! cannot clean" >&2
	fi
    done

    # Now directories wich should be completely empty, no directories
    # nor files should exist in them; currently /srv only
    for dir in /srv ; do
	isinfstab "$dir" || continue
	if ! ismounted "$dir" ; then
	    find "$dir" -mindepth 1 -maxdepth 1 -print0 | xargs -0r rm -rf --
	else
	    echo "$dir is already mounted! cannot clean" >&2
	fi
    done
}

case "$1" in

    start)
	start
	;;

    stop)
	;;
esac
