#!/bin/sh
#
# License: Copyright 2008 SpinetiX S.A. This file is licensed
#          under the terms of the GNU General Public License version 2.
#          This program is licensed "as is" without any warranty of any
#          kind, whether express or implied.
#
# Copyright 1999-2003 MontaVista Software, Inc.
# Copyright 2002, 2003, 2004 Sony Corporation
# Copyright 2002, 2003, 2004 Matsushita Electric Industrial Co., Ltd.
#
### BEGIN INIT INFO
# Required-Start:
# Required-Stop:
# Should-Start:
# Should-Stop:
# Default-Start: S
# Default-Stop: 0 1 2 3 4 5 6
# Short-Description: Detect serial console and lock serial port
# Description: Detect serial console and lock serial port
### END INIT INFO
# chkconfig: S 60 0

# Init script information
INIT_NAME=sercon
DESC=""

SERLOGINPORT=/var/run/seriallogin

port="$(sed -e 's/.*\bconsole=\(tty[^[:digit:][:space:]][[:alnum:]]*\).*/\1/p;d' < /proc/cmdline)"
if [ -z "$port" ]; then
    exit 0;
fi

# We assign the lock to the init process (pid 1), since it has the
# same lifespan as the kernel.

case "$1" in
    start)
	echo -n "Registering $port for system console: lock"
	lockdev -l -p1 "$port"
	RET=$?
	if [ $RET -ne 0 ]; then
	    echo -n " failed ($RET), ";
	else
	    echo -n ", "
	fi
	echo -n "port settings"
	setserial /dev/"$port" closing_wait 100
	RET=$?
	if [ $RET -ne 0 ]; then
	    echo " failed ($RET).";
	else
	    echo "."
	fi
	echo -n "Setting up $port for login"
	echo "$port" > "$SERLOGINPORT"
	RET=$?
	if [ $RET -ne 0 ]; then
	    echo " failed ($RET).";
	else
	    echo "."
	fi
	;;
    stop)
	echo -n "Unlocking $port used by system console"
	lockdev -u -p1 "$port"
	RET=$?
	if [ $RET -ne 0 ]; then
	    echo " failed ($RET).";
	else
	    echo "."
	fi
	echo -n "Unsetting $port for login"
	rm -f "$SERLOGINPORT"
	RET=$?
	if [ $RET -ne 0 ]; then
	    echo " failed ($RET).";
	else
	    echo "."
	fi
	;;
esac
