<?php

class ApiController extends Controller
{
    public $layout='//layouts/json';
    
    static function recover() {        
        $data = array();
        $baseDir = GlobalSettings::$fileBase;
        
        $types = array( "playlist", "playout", "schedule", "media");
        foreach ( $types as $type ){
            // need to check the files first
            $dir = $baseDir . $type;
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != ".." && filetype($dir . "/" . $object) == "dir") {
                    $id = intval($object, 10);
                    $model = Resource::loadModel($type, $id, false );
                    if ( !$model ){
                        GlobalSettings::rrmdir($dir . "/" . $object, true);
                        $data[] = array( "type" => $type, "id" => $id );
                    }
                }
            }
            $models = Resource::loadAll( $type );             
            if ( $models !== null ){
                foreach($models as $model) {     
                    try {
                        $ret = $model->recover();
                        if ( $ret ){
                            $data[] = array( "type" => $type, "name" => $model->name, "id" => $model->id );
                        }
                    } catch(Exception $e) {
                        $data[] = array( "type" => $type, "name" => $model->name, "id" => $model->id, "error" => $e->getMessage(), "details" => $model->errors );
                    }
                }
            }
            
        }
        
        
        $objects = scandir($dir);
        Actions::setAction( 'recovery needed', false );
        return $data;
    }
    public function mustSync() {
        if ( !Actions::getAction( 'content not synced' ) ){
            $this->db()->createCommand('PRAGMA synchronous = FULL;')->execute();
            Actions::setAction( 'content not synced', true );
            $this->db()->createCommand('PRAGMA synchronous = NORMAL;')->execute();
        }
    }    
    public function db() {
        return Yii::app()->dbassets;
    }
    public function checkAccess( $action, $model ){
        if ( $action == 'create' && ( $model == 'media' || $model == 'project' || $model == 'backup')){
            $action = 'upload';
        }
        if ( !Yii::app()->user->checkAccess($action . ucfirst($model) ) ) {
            $this->render( 'response', 
                    array( 'status' => 403,
                           'data' => array (
                               'error' => I18N::t("access denied to {action} {model}", array( "{action}"=> $action, "{model}"=> $model) )
                           ) 
                ) );
            Yii::app()->end();
        }
    }
    public function parseJson( $jsondata ){
        $data = json_decode( $jsondata, true );
        if ( $data===null ) {
            $this->render( 'response', 
                        array( 'status' => 404,
                               'data' => array ('error' => "expecting json"
                                        ) 
                    ) );
            Yii::app()->end();                           
        }
        return $data;
    }
    
    public function loadResource( $id )
	{
        $model = Resource::model()->findByPk($id);
		if( $model===null ){
            $this->render( 'response', 
                        array( 'status' => 404,
                               'data' => array ('error' => "not found"
                                        ) 
                    ) );
            Yii::app()->end();
        }
		return $model;
	}
    public function newModel( $modelType )
	{        
        $model = Resource::newModel( $modelType );
        if( $model===null ){
            $this->render( 'response', 
                        array( 'status' => 404,
                               'data' => array ('error' => "not found"
                                        ) 
                    ) );
            Yii::app()->end();        
        }
        return $model;
	}
    public function loadModel( $type, $id, $loadResource=true )
	{
        $model = Resource::loadModel( $type, $id, $loadResource );
        if( $model===null ){
            $this->render( 'response', 
                        array( 'status' => 404,
                               'data' => array ('error' => "not found"
                                        ) 
                    ) );
            Yii::app()->end();
        }
		return $model;
	}    
    public function actionList( $model, $max = false, $sort = false )
	{
        $this->checkAccess( 'view', $model );
        if ( $model == 'external' && !Yii::app()->branding->hasRight('contentLiveSource') ){
            $this->render( 'response', array( 
                    'status' => 200,
                    'data' => array()
                )
            );
            return;
        }
        $criteria = "";
        if ( $max ){
            $criteria = new CDbCriteria();
            $criteria->limit = intval( $max, 10 );
        }
        if ( $sort ){
            if ( $criteria == "" ) {
                $criteria = new CDbCriteria();
            }
            if ( $sort == 'ASC' ){
                $criteria->order = "modified ASC";
            } else {
                $criteria->order = "modified DESC";
            }
        }  
        if ( $model == 'schedule'){
            // schedule is special as there can be only one schedule
            $models = Schedule::model()->findAll();
            if ( count($models) === 0 ){
                $models[] = new Schedule;
            } 
            $models[0]->setAttributes( $_GET );
            $this->render( 'response', array( 
                    'status' => 200,
                    'data' => $models[0]->desc
                )
            );
            Yii::app()->end();
        } 
        
        $models = Resource::loadAll( $model, $criteria );        
		if ( $models === null ){
            // Model not implemented error
            $this->render( 'response', 
                    array( 'status' => 404,
                           'data' => array (
                               'error' => "not found"
                           ) 
                ) );
            Yii::app()->end();
        }
        
        // Prepare response
        $rows = array();
        foreach($models as $model) {
            $rows[] = $model->listDesc;
        }
                
        $this->render( 'response', array( 
                'status' => 200,
                'data' => $rows
            )
        );
        
	}
    public function actionSet( $model )
	{
        $this->checkAccess( 'edit', $model );
        
        if ( $model !== 'schedule' ) {
            $this->render( 'response', 
                    array( 'status' => 404,
                            'data' => array (
                                'error' => "type not valid"
                            ) 
                 ) );
            Yii::app()->end();
        }
        
        $models = Schedule::model()->findAll();
        if ( count($models) === 0 ){
            $model = new Schedule;
        } else{
            $model = $models[0];
            $model->loadEvents();
        }        
        $data = $this->parseJson( file_get_contents("php://input") );
        $model->events = $data;        
        $model->setAttributes( $_GET );
        $params = $this->saveModel( $model );
        
        $this->render( 'response', $params );
        
	}
    public function actionClear( $model )
	{
        $this->checkAccess( 'edit', $model );
        
        if ( $model !== 'schedule' ) {
            $this->render( 'response', 
                    array( 'status' => 404,
                            'data' => array (
                                'error' => "type not valid"
                            ) 
                 ) );
            Yii::app()->end();
        }
        
        $models = Schedule::model()->findAll();
        if ( count($models) !== 0 ){
            $model = $models[0];
            $transaction = $this->db()->beginTransaction();
            try {                            
                if( !$model->delete() ){               
                    throw new Exception( "delete resource failed" );
                }                 
            } catch(Exception $e) { // an exception is raised if a query fails
                $transaction->rollback();               
                return $this->render( 'response', array(
                    'status' => 500,
                    'data' => array (
                                'error' => $e->getMessage(),
                                'details' => $model->errors
                            )
                ) );
            }
            $transaction->commit();
        }        
        return $this->render( 'response', array(
                'status' => 200,
                'data' => array() 
        ) );               
	}
    public function actionGet( $model, $id )
	{
        $this->checkAccess( 'view', $model );
        
        $model = $this->loadModel( $model, $id );
        $desc = $model->desc;
        
        $models = Schedule::model()->findAll();
        if ( count($models) !== 0 ){            
            $current = $models[0]->getCurrentEvent();
            if (is_array($current) && isset($current['resource']) && $current['resource']['id'] === $model->id ){
                $desc['active'] = true;
            }
        } 
        
		$this->render( 'response', array(
                'status' => 200,
                'data' => $desc
        ) );
	}
    
    public function actionCreate( $model )
	{
        $params = array('status' => 404,
                        'data' => array ('error' => "not found"
                                        ) 
                    );
        if ( $model === 'media' && isset($_FILES['media']) ){
            $file = CUploadedFile::getInstanceByName( 'media' );
            if ( $file && $file->extensionName == '7z' ) {
                // This should be an elementi archive project, however, for backward compatibility, this could
                // also be a backup that the user renamed to 7z instead of using the 'bck' extension.
                // if the bakcup contains an index.svg 
                $zip = new ZipHandler;
                if ( $zip->open( $file->tempName, "7z", true) ){
                    if ( in_array("index.svg", $zip->content) ) {
                        // this is an archive
                        $model = 'project';                    
                    } else if ( count($zip->folders)>1 && in_array( $zip->folders[1] . DIRECTORY_SEPARATOR. "index.svg", $zip->content) ) {
                        // this is an archive with a base folder
                        $model = 'project';                    
                    } else if ( in_array(ResourceBackup::$dbName, $zip->content) ){
                        // this is a backup
                        $model = 'backup';
                    } else {
                        $data =  array('status' => 404,
                            'data' => array ('reload' => false, 
                                             'error' => I18N::t('Cannot detect the archive type.'), 
                                             'details' => $zip->content
                                            ) 
                        ); 
                        return $this->render( 'response', $data );
                    }
                } else {
                    $data =  array('status' => 404,
                        'data' => array ('reload' => false, 
                                         'error' => I18N::t('Cannot open archive.'), 
                                         'details' => $zip->errors
                                        ) 
                    ); 
                    return $this->render( 'response', $data );
                }
            } else if ( $file && $file->extensionName == 'bck' ){
                $model = 'backup';
            }
        }
        
        $this->checkAccess( 'create', $model );
        
        // Get the respective model instance
        switch( $model )
        {
            case 'apps':
                $params = $this->createApps();
                break;
            case 'media':
                $params = $this->createMedia();
                break;
            case 'backup':
                $params = $this->uploadBackup( );
                break;
            case 'project':
                $params = $this->createProject( );
                break;
            default:
                $params = $this->createModel( $model );
                break; 
        }
        $this->render( 'response', $params );
        
	}
    
	public function actionUpdate( $model, $id, $detail=false )
	{
        $this->checkAccess( 'edit', $model );
        
        $params = array('status' => 404,
                        'data' => array ('error' => "not found"
                                        ) 
                    );
        switch( $model )
        {
            case 'media':                
                $params = $this->updateMedia( $model, $id, "PUT", $detail );
                break;
            default:                
                $params = $this->updateModel( $model, $id );
                break; 
        }
        
        $models = Schedule::model()->findAll();
        if ( count($models) !== 0 ){
            $current = $models[0]->getCurrentEvent();
            if ( is_array($current) && isset($current['resource']) && $current['resource']['id'] === $id ){
                Schedule::forceReload();
            }
        } 
        
        $this->render( 'response', $params );
	}
    
    public function actionDelete( $model, $id, $force = false )
	{
        $this->checkAccess( 'delete', $model );
        $data =  array();
        $model = $this->loadModel( $model, $id);
        if ( !$force && count($model->parents)>0 ){
            $parents = array();
            foreach ( $model->parents as $parent ){
                $parents[] = $parent->getListDesc( false );
            }
            return $this->render( 'response', array(
                'status' => 202,
                'data' => $parents 
            ) );
        }
        $transaction = $this->db()->beginTransaction();
        try {            
            if ( $model instanceof Resource){
                $mainModel = $model->getMainResource( true );
                if ( $mainModel && !$mainModel->delete() )
                    throw new Exception( "delete main resource failed" );
            }
            if( !$model->delete() ){               
                throw new Exception( "delete resource failed" );
            } 
            if ( $model->type === 'playout' ){
                $data['variables'] = $model->variablesToDelete;
            }
        } catch(Exception $e) { // an exception is raised if a query fails
            $transaction->rollback();
            foreach ($model->parents as $parent){
                $parent->rollback(); // may throw
            }
            // warning should also roll back all the actions on the parents files
            return $this->render( 'response', array(
                'status' => 500,
                'data' => array (
                            'error' => $e->getMessage(),
                            'details' => $model->errors
                        )
            ) );
        }
        $transaction->commit();
       
        return $this->render( 'response', array(
                'status' => 200,
                'data' => $data 
            ) );
	}
    
    public function uploadBackup(  )
    {
        $resourceBackup = new ResourceBackup;
        $resourceBackup->file = CUploadedFile::getInstanceByName( 'media' );;
        if ( $resourceBackup->validate() && $resourceBackup->restore( ) ) {
            $data = array('status' => 200,
                'data' => array ('reload' => true, 
                                 'info' => $resourceBackup->actions 
                ) 
            );                    
        } else {
            $data =  array('status' => 404,
                'data' => array ('reload' => false, 
                                 'error' => I18N::t('Some error occured while uploading the backup file.').' '.I18N::t('Please reload the page.'), 
                                 'details' => $resourceBackup->errors, 
                                 'info' => $resourceBackup->actions 
                                ) 
            );                    
        }
        return $data;
    }
    public function createProject() {
        if( !isset($_POST['data']) ) {
            return array( 
                    'status' => 400,
                    'data' => array( 'error' => "missing parameters"
                ) );            
        }
        $data = $this->parseJson( $_POST['data'] );
        
        $model = $this->newModel( 'project' );
        $model->attributes = $data;
        
        $transaction = $this->db()->beginTransaction();
        try {
            if( !$model->processFile( 'media' ) ){               
                throw new Exception( "processing file failed"  );
            }
            $model->scenario = 'file';
            if( !$model->save() ) {                    
                throw new Exception( "save failed"  );
            }            
        } catch(Exception $e) { // an exception is raised if a query fails
            $model->rollback();
            $transaction->rollback();
            return array( 
                        'status' => 400,
                        'data' => array (
                            'error' => $e->getMessage(),
                            'details' => $model->errors
                        )
                    );
        }
        $transaction->commit();
        return array( 
                'status' => 201,
                'data' => $model->desc
            );
    }
    
    public function createMedia() {
        if( !isset($_POST['data']) ) {
            return array( 
                    'status' => 400,
                    'data' => array( 'error' => "missing parameters"
                ) );            
        }
        $data = $this->parseJson( $_POST['data'] );
        
        $this->mustSync();
        
        $resource = new Resource;
        $resource->attributes = $data;
        $resource->type = "media";
        $model = $resource;
        
        $transaction = $this->db()->beginTransaction();
        try {
            if( !$resource->save() ){               
                throw new Exception( "save failed"  );
            }
            if ( isset($_FILES['media']) ){
                $model = new Media;
                $model->id = $resource->id;
                if( !$model->processFile( 'media' ) ){                    
                    throw new Exception( "processing failed" );
                }
                $model->scenario = 'file';
                if( !$model->save() ) {                    
                    throw new Exception( "save failed"  );
                }
            } 
        } catch(Exception $e) { // an exception is raised if a query fails
            $model->rollback();
            $transaction->rollback();
            return array( 
                        'status' => 400,
                        'data' => array (
                            'error' => $e->getMessage(),
                            'details' => $model->errors
                        )
                    );
        }
        $transaction->commit();
        return array( 
                'status' => 201,
                'data' => $model->desc
            );
    }
    
    public function updateMedia( $model, $id, $type, $detail = false ){
        $model = $this->loadModel( $model, $id );  
        $status = 200;
        if ( $model instanceof Resource ){
            $resource = $model;
        } else {
            $resource = $model->resource;
        }
        
        $this->mustSync();
        
        $transaction = $this->db()->beginTransaction();
        try {            
            if ( $type=='PUT' && !$detail ){
                Yii::log("update end point missing".print_r($_GET, true)." -> ".$type, 'warning', 'spx.api');                
                throw new Exception( "missing parameters"  );
            }
            if ( ( $type=='PUT' && $detail=="media" ) || 
                 ( $type=='POST' && isset($_FILES['media']) ) ){
                if ( !($model instanceof Media) ){
                    $id = $model->id;
                    $model = New Media;
                    $model->id = $id;
                }

                $model->processFile( $type=='PUT'?'PUT':'media' );
                $status = 201;
                $model->scenario = 'file';
                if( !$model->save() ) 
                    throw new Exception("save $model->type failed");
                            
            }
            
            if ( $type=='PUT' && $detail=="data" ) {
                $data = $this->parseJson( file_get_contents("php://input") );                
            } else if ( isset($_POST['data']) ) {
                $data = $this->parseJson( $_POST['data'] );                
            } else {
                $data = null;
            }
            if ( $data ) { 
                $resource->attributes = $data;
                if( !$resource->save() ) 
                    throw new Exception( "save failed" );
                $model->attributes = $data;
                $model->scenario = 'data';
                if( !$model->save() ) 
                    throw new Exception( "save failed" );
            }
            
        } catch(Exception $e) { // an exception is raised if a query fails
            $model->rollback();
            $transaction->rollback();
            return array( 
                        'status' => 400,
                        'data' => array (
                            'data' => $data,
                            'error' => $e->getMessage(),
                            'details' => array_merge( 
                                    $model->errors,
                                    $resource->errors
                            )
                        )
                    );
        }
        $transaction->commit();
        // actions to trigged on the media (create snapshot for instance, 
        // or update the db)
        return array( 
            'status' => $status,
            'data' => $model->desc
        );
    }
    public function createApps() {
        if( !isset($_POST['data']) ) {
            Yii::log("missing data parameters" . print_r($_POST, true), 'warning', 'spx.api');                                
            return array( 
                    'status' => 400,
                    'data' => array( 'error' => "missing parameters"  
                ) );            
        }
        if( !isset($_FILES['apps']) ) {
            Yii::log("missing apps parameters" . print_r($_FILES, true), 'warning', 'spx.api');                                            
            return array( 
                    'status' => 400,
                    'data' => array( 'error' => "missing parameters"  
                ) );            
        }

        $this->mustSync();
        
        $model = new Apps;
        $data = $this->parseJson( $_POST['data'] );
        $model->attributes = $data;
        $model->setAppsFile( 'apps' );
        $transaction = $this->db()->beginTransaction();
        try {
            if( !$model->save() ){               
                throw new Exception( "save failed" );
            }            
        } catch(Exception $e) { // an exception is raised if a query fails
            $model->rollback();
            $transaction->rollback();
            return array( 
                        'status' => 400,
                        'data' => array (
                            'error' => $e->getMessage(),
                            'details' => $model->errors
                        )
                    );
        }
        $transaction->commit();
        return array( 
                'status' => 201,
                'data' => $model->desc
            );
    }
    
    public function createModel( $modelType ) {
        $data = $this->parseJson( file_get_contents("php://input") );
        
        $model = $this->newModel( $modelType );
        $model->attributes = $data;
        
        $this->mustSync();
        
        $transaction = $this->db()->beginTransaction();
        try {
            if( !$model->save() )
                throw new Exception( "save failed"  );
        } catch(Exception $e) { // an exception is raised if a query fails
            $model->rollback();
            $transaction->rollback();
            return array( 
                        'status' => 400,
                        'data' => array (
                            'error' => $e->getMessage(),
                            'details' => $model->errors
                        )
                    );
        }
        $transaction->commit();           

        return array( 
            'status' => 201,
            'data' => $model->desc
        );                
    }
    public function saveModel( $model ){   
        
        $this->mustSync();
        
        $transaction = $this->db()->beginTransaction();
        try {
            if( !$model->save() ){
                throw new Exception( "save failed" );
            }
        } catch(Exception $e) { // an exception is raised if a query fails
            $model->rollback();
            $transaction->rollback();
            return array( 
                        'status' => 400,
                        'data' => array (
                            'error' => $e->getMessage(),
                            'details' => $model->errors
                        )
                    );
        }
        $transaction->commit();
        return array( 
            'status' => 200,
            'data' => $model->desc
        );
    }
    public function updateModel( $type, $id ){
        
        $model = $this->loadModel( $type, $id );  
        
        $data = $this->parseJson( file_get_contents("php://input") );
        $model->attributes = $data;
        
        return $this->saveModel( $model );
        
    }
    
    
	public function actionPost( $model, $id, $detail=false )
	{
        $this->checkAccess( 'edit', $model );
        
        $params = array('status' => 404,
                        'data' => array ('error' => "not found" 
                                        ) 
                    );
        switch( $model )
        {
            case 'media':
                $params = $this->updateMedia( $model, $id, 'POST' );
                break;   
        }
        $this->render( 'response', $params );
        
	}

    public function actionOption( )
	{
        $this->render( 'response', array(
                'status' => 200,
                'data' => array()
        ) );
	}
    public function actionRecover( )
	{
        $this->render( 'response', array(
                'status' => 200,
                'data' => self::recover()
        ) );
	}
	
}