<?php

/**
 * This is the model class for table "Actions".
 *
 * The followings are the available columns in table 'Actions':
 * @property string $name
 * @property string $type
 * @property string $value
 */
class Actions extends AssetsActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Actions';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('type, name, value', 'required'),
			array('type', 'in', 'range'=>array('boolean', 'integer', 'double', 'string' ) ),
            array('name, value', 'length', 'max'=>64),
            array('id', 'numerical', 'integerOnly'=>true, 'on'=>'update' ),
			// The following rule is used by search().
			array('name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'id',
			'type' => 'type',
            'name' => 'name',
            'value' => 'value'
		);
	}
    
    public function getRealValue() {
        switch ( $this->type ){
            case 'integer':
                return intval( $this->value, 10 );
            case 'boolean':
                return $this->value == "true";
            case 'double':
                return floatval( $this->value );
            case 'string':
                return $this->value;
        }
    }
    public function setRealValue( $val ) {
        $this->type = gettype( $val );
        if ( $this->type == 'boolean' ){
            $this->value = $val?"true":"false";
        } else {
            $this->value = $val;
        }        
    }
    public static function getAction($name)
	{   
        $action = self::model()->findByAttributes(array( 'name'=>$name ));
        if ( $action ){
            return $action->getRealValue();
        } else {
           return null;
        }
	}
    public static function setAction($name, $value)
	{
        $action = self::model()->findByAttributes(array( 'name'=>$name ));
        if ( !$action ){
           $action =  new Actions();
           $action->name = $name;
        } else {
            if ( $action->getRealValue() === $value ){
                return true;
            }
        }
        $action->setRealValue( $value );
        return $action->save();
	}
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria=new CDbCriteria;
        $criteria->compare('name',$this->name, true);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Resource the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
