<?php


class ActionSet extends CWidget
{
    var $actions = array();
    var $style = 'auto'; // one fo the following 'text', 'icon', 'all', 'auto'
    var $size = false;
    var $options = array();
    var $presets;
    public function init(){
        parent::init();
        
    }
    public function addOptions( &$options, $newOptions ){
        foreach( $newOptions as $name => $value ){
            $sep = "; ";
            switch ( $name ){
                case 'class': $sep = " "; break;
                case 'data-bind': $sep = ", "; break;
            }
            if ( isset( $options[$name]) )
                $options[$name] .= $sep.$value;
            else
                $options[$name] = $value;
        }
    }
    public function addClass( &$options, $class ){
        $this->addOptions( $options, array( 'class' => $class) );
        $this->presets = array(
            'save' => array( 'icon'=> 'save', 'title' => I18N::t('Save'), 'type' => 'primary' ),
            'apply' => array( 'icon'=> 'save', 'title' => I18N::t('Save'), 'type' => 'primary' ),
            'ok' => array( 'icon'=> 'check', 'title' => I18N::t('OK') ),
            'new' => array( 'icon'=> 'plus', 'title' => I18N::t('New Playout') ),
            'upload' => array( 'icon'=> 'download', 'title' => I18N::t('Upload Media'), "class" => "fileinput-button" ),
            'backup' => array( 'icon'=> 'upload', 'title' => I18N::t('Backup') ),
            'properties'=> array( 'icon'=>'gear', 'title' => I18N::t('Setup')),   
            'calendar'=> array( 'icon'=>'calendar', 'title' => I18N::t('Calendar')),
            'large'=> array( 'icon'=>'stop', 'title' => I18N::t('Large')),  
            'medium'=> array( 'icon'=>'th-large', 'title' => I18N::t('Medium')),  
            'small'=> array( 'icon'=>'th', 'title' => I18N::t('Small')),  
            'list'=> array( 'icon'=>'list', 'title' => I18N::t('List View')),  
            'edit'=> array( 'icon'=>'pencil', 'title' => I18N::t('Edit')),  
            'remove'=> array( 'icon'=>'times', 'title' => I18N::t('Remove')),
            'clear'=> array( 'icon'=>'times', 'title' => I18N::t('Clear')),
            'horizontal' => array( 'icon'=> 'stop stretch-h', 'title' => I18N::t('Horizontal')),
            'vertical' => array( 'icon'=> 'stop stretch-v', 'title' => I18N::t('Vertical')),
            'copy' => array( 'icon'=> 'copy', 'title' => I18N::t('Copy')),
            'selectall' => array( 'icon'=> 'check-square-o', 'title' => I18N::t('Select All')),
            'unselectall' => array( 'icon'=> 'square-o', 'title' => I18N::t('Unselect All'))
        );
    }
    
    function button( $action ){
        if ( isset($action['preset']) ){
            if ( isset( $this->presets[ $action['preset'] ]) ){
                $action = array_merge($this->presets[ $action['preset'] ], $action);                
            }
            unset($action['preset'] );
        }
        if ( isset($action['html']) ){
            $html = $action['html'];
            unset($action['html']);
        } else {
            $html = "";
        }
        if ( isset($action['icon']) ) {
            if ( $this->style === 'icon' || $this->style === 'all' || $this->style === 'auto') {
                $class =  "fa fa-fw fa-".$action['icon'];
                if ( $this->style === 'auto' ){
                    $html .= CHtml::tag("span", array( "class" => "visible-xs-inline visible-sm-inline" ) , CHtml::tag("i", array( "class" =>$class ), "" ) );
                } else {
                    $html .= CHtml::tag("i", array( "class" =>$class ), "" );
                }
                
            }
            unset($action['icon']);
        }
        if ( $this->style === 'text' || $this->style === 'all' || $this->style === 'auto' ){
            if ( isset($action['title']) ){
                $class = "";
                if ( $this->style === 'auto' ){
                    $class .= "hidden-xs hidden-sm";
                }
                $html .= CHtml::tag("span", array( "class" =>$class ), $action['title'] );              
            }
        }
        
        $class = "btn";
        if ( $this->size ){
            $class .= " " . $this->size;
        }
        if ( isset($action['type']) ){
            $class .= " btn-".$action['type'];
            unset($action['type']);
        } else {
            $class .= " btn-default";
        }
        
        $options = $action;
        $this->addClass( $options, $class );        
        
        return CHtml::tag("span", $options, $html );
    }

    
    public function run()
    {
        $this->addClass( $this->options, "btn-group" );  
        echo CHtml::openTag("span", $this->options );
        foreach ( $this->actions as $action ){  
            if ( !isset( $action['visible']) || $action['visible'] ){
                echo $this->button( $action );
            }
        }
        echo CHtml::closeTag("span" ); 
    }
}
