<?php
/* @var $this MainController */

$this->registerSpxScript( 'resources.js' );
$this->registerSpxScript( 'work.js' );

$this->breadcrumbs[] = $this->title = '&nbsp;'; 

$agent = Yii::app()->request->userAgent;
if ( strpos($agent, 'iPhone OS 7') === false && strpos($agent, 'iPad OS 7') === false ){
    $multiple = 'multiple="multiple" ';
} else {
    $multiple = "";
}
$schedule = $this->createUrl("playout/schedule" );
$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array( 
        array( 'preset'=> 'upload',
                'html' => '<input type="file" '.$multiple.'name="media" data-bind="jQueryFileupload: resources.addMediaFile, args: {url: spxapi.media.uri} " />',
                'id'=>"uploadButton",
                'visible' => Yii::app()->user->checkAccess('uploadMedia')
        ),
        array( 'icon'=> 'film', 'title'=> I18N::t('New Playlist'), 'data-bind' => 'click: createPlaylist',
                'id'=>"createNewPlaylist",
                'visible' => Yii::app()->user->checkAccess('createPlaylist')),
        array( 'icon'=> 'desktop', 'title'=> I18N::t('New Playout'), 'data-bind' => 'click: create',
                'id'=>"createNewPlayout",
                'visible' => Yii::app()->user->checkAccess('createPlayout')),
        
    ),
    'options' => array( 
        "class" => "pull-left",
        
    )    
), true); 
$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array( 
        array( 'preset'=> 'selectall',
                'data-bind' => 'click: selectAll, css: { }',
                'id'=>"selectallButton"
        ),array( 'preset'=> 'unselectall',
                'data-bind' => 'click: unselectAll',
                'id'=>"unselectallButton"
        ),array( 'preset'=> 'remove',
                'data-bind' => 'click: deleteResources, css: { disabled: resources.selected().length === 0 }',
                'id'=>"deleteButton",
                'visible' => Yii::app()->user->checkAccess('deleteMedia')
        ),
        array( 'preset'=> 'backup',
                'data-bind' => 'click: backupResources, css: { disabled: resources.selected().length === 0 }',
                //'onclick' => 'location.href = "'.$this->createUrl("/api/backup/create").'"; loadButtonWithCheck( $(this) );',
                'id'=>"backupButton"
        ),                
    ),
    'options' => array( 
        "class" => "pull-right"
    )
), true); 

$this->topBar .= $this->helpButton( array(
    'steps' => array(
        array( 
            'intro' => I18N::t('This page let you manage files: Media files, Playouts and Playlist')),
        array( 
            'element' => '.spx-table-topbar',
            'intro' => I18N::t('You can search and select files using the tool bar'),            
        ),
        array( 
            'element' => '.btn-toolbar > span:first-child',
            'intro' => I18N::t('Select the size of the icon'), 
            "position" => 'right'
        ),
        array( 
            'element' => '.btn-toolbar > span:last-child',
            'intro' => I18N::t('Switch between horizontal of vertical files'),  
            "position" => 'right'
        ),
        array( 
            'element' => '#iconViewSelect',
            'intro' => I18N::t('Select the type of files to be displayed'),
            "position" => 'left'
        ),
        array( 
            'element' => '#iconViewSearch',
            'intro' => I18N::t('Search files using name or keywords'),
            "position" => 'left'
        ),
        array( 
            'element' => '.type-playout',
            'intro' => I18N::t('Click on a file to edit it'),            
        ),
        array( 
            'element' => '#iconViewTable',
            'intro' => I18N::t('Upload media using drag & drop from explorer'),
            'visible' => Yii::app()->user->checkAccess('uploadMedia')
        ),
        array( 
            'element' => '#uploadButton',
            'intro' => I18N::t('Or browse for media'),
            "position" => 'right',
            'visible' => Yii::app()->user->checkAccess('uploadMedia')
        ),        
        array( 
            'element' => '#createNewPlayout',
            'intro' => I18N::t('Create new Playout'),
            "position" => 'right',
            'visible' => Yii::app()->user->checkAccess('createPlayout'),
        ),
        array( 
            'element' => '#createNewPlaylist',
            'intro' => I18N::t('Create new Playlist'),
            "position" => 'right',
            'visible' => Yii::app()->user->checkAccess('createPlaylist')
        ),     
        array( 
            'element' => '#iconViewTable .spx-gallery>div',
            'intro' => I18N::t('Select one or more file using the check box'),            
        ),
        array( 
            'element' => '#backupButton',
            'intro' => I18N::t('Create a backup of all selected files'),
            "position" => 'left'
        ),
        array( 
            'element' => '#deleteButton',
            'intro' => I18N::t('Delete all selected files'),
            "position" => 'left'
        )
    )
));

?>
<div class="row" >
    <div class='col-md-12' data-bind="with: resources">
<?php
$this->widget('AssetsSelect', array(   
    'tableOptions'=>array( "id"=>"iconViewTable" ),
    'selectOptions'=>array( "id"=>"iconViewSelect" ),
    'searchOptions'=>array( "id"=>"iconViewSearch" )
));
?>    
    </div>
</div>
<?php if ( Yii::app()->user->checkAccess('createPlayout') ) { ?>
<div class="modal fade" id="newTemplateModal">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span></button>        
      </div>
      <div class="modal-body" data-bind="with: newTemplate, css: {'spx-vertical': newTemplate.vertical(), 'spx-horizontal': !newTemplate.vertical() }">
          <div class="row spx-table-topbar" <?php echo "id='".$this->id."'";?> >   
    <div class="col-md-4">
<?php
$this->widget('ActionSet', array(
    'actions' => array(
        array( 'preset'=> 'horizontal',
                "data-bind" => "click: function(){ vertical( false ); }, css: { active: !vertical() }" ),
        array( 'preset'=> 'vertical',
                "data-bind" => "click: function(){ vertical( true ); }, css: { active: vertical() }" ),
    ),
    'style' => 'icon',
    'size' => 'btn-sm'
));
?>
    </div>
    <div class="col-md-4 col-md-offset-4">        
        <div class="form-group">
            <input class="form-control typeahead" type="text" placeholder="<?php echo I18N::t("Search");?>" data-bind="typeahead: inputSearch, typeaheadDataset: searchDatasets"/>
        </div>
    </div>
</div>
        <table class="no-border table" data-bind="dataTable: datatableOptions, dataTableTarget: table, visible: tableView">
            <thead class="no-border">
            </thead>
            <tbody class="no-border-y">            
            </tbody>            
        </table>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<?php } ?>
<script type="text/javascript" >
//<![CDATA[
<?php
    $models = array( 'playout', 'playlist', 'media', 'project' );
    $actions = array( 'delete', 'edit', 'copy' );
    
    $resources = array();
    $visible = array();
    foreach ( $models as $idx => $model ){
        if ( Yii::app()->user->checkAccess('view'. ucfirst($model)) ) {
            $resources[] = $model;
        }
        foreach ( $actions as $action ){
            if ( !Yii::app()->user->checkAccess( $action. ucfirst($model)) ) {
                $visible[$model][$action] = false;
            }
        }
    }
    
    $options = array(
        "newTemplateModal" => "js:$('#newTemplateModal')",
        "links" => array(
            "template" => $this->createUrl("playout/edit", array('templateId'=>"[id]") ),
            "playout" => $this->createUrl("playout/edit", array('id'=>"[id]") ),
            "playlist" => $this->createUrl("playlist/edit", array('id'=>"[id]") ),
            "media" => $this->createUrl("media/edit", array('id'=>"[id]") ),
            "project" => $this->createUrl("project/edit", array('id'=>"[id]") ),
            "apps" => $this->createUrl("apps/edit", array('id'=>"[id]") ),
            "backup" => $this->createUrl("/api/backup/create", array('ids'=>"[id]") ),            
        ),
        'resources' => $resources,
        'visible' => $visible,
        'noNewPlayout' => !Yii::app()->user->checkAccess('createPlayout'),
        'keepHidden' => Yii::app()->user->checkAccess('manageTemplate')
    );
    if ( isset($filter) ) {
        $options['filter'] = $filter;
    }
?>
var model = new WorkEdit(<?php echo CJavaScript::encode( $options ); ?>);

ko.applyBindings( model );
//]]></script>
