<?php
/* @var $this MainController */

$this->registerSpxScript( 'resources.js' );

$this->breadcrumbs[] = $this->title = I18N::t('Playout'); 

$this->beginWidget('AssetsList', array(
    'useDropZone' => false,
    'model' => 'playoutList',
    'url' => 'spxapi.playout.uri',
    'resources' => "['playout']"
)); 
$this->endWidget();
$schedule = $this->createUrl("playout/schedule" );
$this->topBar .= $this->iconSet( array(
        array( 'icon'=> 'plus', 'title' => I18N::t('New Playout'), 
                'data-bind' => 'click: create')
    ),
    array( 
        "class" => "pull-right"
    )
);

?>
<script type="text/javascript" >
//<![CDATA[
playoutList.editLinkTemplate = "<?php echo $this->createUrl("playout/edit", array('id'=>"[id]") ); ?>";
playoutList.open = function ( model ) {
    var where = playoutList.editLinkTemplate.replace( "%5Bid%5D", model.id );;
    location.href = where;
};
playoutList.create = function () {
    var where = playoutList.editLinkTemplate.replace( "%5Bid%5D", "" );;
    location.href = where;
};
playoutList.copy = function ( model ) {
    var source = {
        name: model.resourceModel.name() + " - Copy",
        sourceId: model.id
    };
    spxapi[model.resourceModel.type()].create( source ).done( playoutList.addMediaFile );   
};

ko.applyBindings( playoutList );

//]]></script>
