<?php
/* @var $this MediaController */
// If neededing additonal scripts
//Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/ascript/file',CClientScript::POS_END);

$this->breadcrumbs = array( 
    "Templates" =>"/assets/template/list",
    "ko" =>"breadcrumbs"
);
$this->title = I18N::t("Templates");

$this->registerSpxScript( 'apps.js' );
$this->registerSpxScript( 'playlist.js' );
$this->registerSpxScript( 'playout.js' );
$this->registerSpxScript( 'resources.js' );

$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array(
        array( 'preset'=> 'properties',                 
                'data-bind' => 'click: function(){ playout().editProperties( !playout().editProperties() ); }, '.
                                'css: { active: playout().editProperties()}, '),
        array( 'preset'=> 'apply',
                'data-bind' => 'click: apply, visible: status.isDirty(), css: { disabled: playout().overlap() }')
    ),
    'options' => array( 
        "class" => "pull-right"        
    )
), true); 

$this->topBar .= $this->widget('ActionSet', array(
    'actions' => array(
        array( 'icon'=> 'exchange', 'title' => 'Swap Horizontal',                 
                'data-bind' => 'click: playout().switchHorizontal',
                'id' => 'HorizontalSwitch'),
        array( 'icon'=> 'exchange fa-rotate-90', 'title' => 'Swap Vertical',                 
                'data-bind' => 'click: playout().switchVertical',
                'id' => 'VerticalSwitch'),
        array( 'icon'=> 'arrows-h', 'title' => 'Fill Horizontal',                 
                //'data-bind' => 'click: playout().fillHorizontal, css: { disabled: !playout().selectedLayer() || playout().selectedLayer().background }',
                'data-bind' => 'click: playout().fillHorizontal',
                'id' => 'FillHorizontal'),
        array( 'icon'=> 'arrows-v', 'title' => 'Fill Vertical',                 
                //'data-bind' => 'click: playout().fillVertical, css: { disabled: !playout().selectedLayer() || playout().selectedLayer().background }',
                'data-bind' => 'click: playout().fillVertical',
                'id' => 'FillVertical'),
        
    ),
    'options' => array( 
        "class" => "pull-right", 
        "data-bind" => 'visible: editLayout()'
    )
), true);

$this->renderPartial("edit/top");
?>

<script type="text/javascript" >
//<![CDATA[
var model = new PlayoutEdit({    
    type: 'template',
<?php if ( isset($id) ) echo "\tid: '".$id."'";?> 
});

Layer2('setTarget', $('#templateEditZone') );

// add drag utils to the model
(function ( model ){
    var handle_click = true;
    model.hideSVG = ko.observable( false );
    model.startResize  = function( layer, event, ui ) { 
        model.hideSVG( true );
    };
    model.startDrag = function( layer, event, ui ) { 
        model.selectLayer( layer, true ); 
        handle_click = false;
    };
    model.stopDragResize = function( layer, event, ui ) { 
        handle_click = false;
        model.hideSVG( false );
    };
    model.click = function( layer ) { 
        if ( handle_click )
            model.selectLayer( layer ); 
        handle_click = true;    
    };
    model.editTemplateName = function( layer ) {        

        if ( layer.resizable || layer.draggable )
            return "position-template";
        else 
            return "fixed-template";        
    }; 
}(model));

ko.applyBindings( model );

//]]></script>