;(function(window, document, Darkroom) {
  'use strict';

  Darkroom.plugins['save'] = Darkroom.Plugin.extend({
    defaults: {
      callback: function() {
            if ( this.options.saveCallback ) {
                var format = this.options.format || 'jpeg';
                var data = this.darkroom.snapshotImage({
                    format: format,
                    quality: 0.9                    
                });
                var mimeType = data.substr(5, data.indexOf(";")-5);                    
                var stringView  = StringView.makeFromBase64( data.substr( data.indexOf(",")+1 ) );
                this.options.saveCallback( stringView.rawData, mimeType  );

            }
            this.darkroom.selfDestroy();
        }
    },
    initialize: function InitDarkroomSavePlugin() {
      var buttonGroup = this.darkroom.toolbar.createButtonGroup();

      this.destroyButton = buttonGroup.createButton({
        image: 'save'
      });

      this.destroyButton.addEventListener('click', this.options.callback.bind(this));
    },
  });
})(window, document, Darkroom);
