(function ($) {

    var Timezone = {
        init: function (cities, formatName, addLocal ) {
            this.cities = [];
            this.formatName = formatName;
            if ( addLocal ){
                this.cities.push({
                    id: "",
                    text: formatName(""),
                    offset: ""
                });
            }
            for (var i = 0; i < cities.length; i++) {
                var id = cities[i].substr(3);                
                var offset = moment.tz( id ).format('Z')
                this.cities.push({
                    id: id,
                    text: formatName(cities[i]),
                    offset: offset
                });
            }

            this.cities.sort(function (a, b) {
                if (a.offset === "") {
                    return -1;
                }
                if (b.offset === "") {
                    return 1;
                }
                return parseInt(a.offset.replace(":", ""), 10) - parseInt(b.offset.replace(":", ""), 10);
            });

            this.html = this.getHTMLOptions();            
        },
        getHTMLOptions: function () {
            var html = '';            
            var i, c = this.cities.length, city;

            for (i = 0; i < c; i++) {
                city = this.cities[i];
                if ( !city.text ){
                    continue;
                }
                if ( city.id === "" || !city.id ){
                    html += '<option data-offset="0" value="' + city.id + '">' + city.text + '</option>';
                } else {
                    html += '<option data-offset="' + city.offset + '" value="' + city.id + '">(UTC ' + city.offset + ') ' + city.text + '</option>';
                }
            }
            return html;
        },
        addNames: function (select) {
            return $(select).empty().append($(this.html));
        }
    };

    $.fn.timezones = function (opts, value ) {

        if (typeof opts === "string") {
            if ( opts in Timezone ){
                return Timezone[opts].apply(Timezone, Array.prototype.slice.call(arguments));
            } 
            return $(this).select2(opts, value);
        }

        opts = $.extend({}, $.fn.timezones.defaults, opts);
        if (opts.tz.zones.length !== 0) {
            moment.tz.load(opts.tz);
        }

        if (!opts.formatName || typeof opts.formatName !== 'function') {
            opts.formatName = function (key) {
                return spxapi.locale.formatTimezone(key);                
            };
        }
        if (opts.tz.names.length === 0) {
            //opts.tz.names = moment.tz.names();            
            opts.tz.names = spxapi.locale.getTimezones();
        }
        Timezone.init(opts.tz.names, opts.formatName, opts.addLocalTime );

        return this.each(function(){
            Timezone.addNames(this);     
            $(this).select2( opts );
            return this;
        });        
    };

    $.fn.timezones.defaults = {
        addLocalTime: true,
        tz: {
            zones: [],
            names: []
        }
    };
    
})(jQuery);

ko.bindingHandlers.timezonepicker = {
    'after': ['options', 'foreach'],
    init: function (element, valueAccessor, allBindingsAccessor) {
        //initialize timezonepicker with some optional options
        var options = $.extend({
            width: '100%'
        }, allBindingsAccessor().selectOptions);

        $(element).timezones(options);

        return ko.bindingHandlers.value.init(element, valueAccessor, allBindingsAccessor);
    },
    update: function (element, valueAccessor, allBindings) {
        var ret = ko.bindingHandlers.value.update(element, valueAccessor, allBindings);
        var value = ko.utils.unwrapObservable(valueAccessor());
        $(element).timezones("val", value);
        return ret;
    }
};
$(function(){
    $(".timezonepicker").each( function() {
        $(this).timezones({ addLocalTime: false });
        var defaultVal = $(this).attr("data-default");
        if ( !defaultVal || defaultVal === "" ){
            defaultVal = moment.tz.guess();
        }
        $(this).timezones("val", defaultVal );
    });
});