function addActions( target, links, visible ) {
    
    var show = {};
    show.apps = $.extend( { edit: true }, visible.apps );
    show.playout = $.extend( { delete: true, backup: true, copy: true, edit: true }, visible.playout );
    show.playlist = $.extend( { delete: true, backup: true, copy: true, edit: true }, visible.playlist );
    show.media = $.extend( { delete: true, edit: true }, visible.media );
    show.project = $.extend( { delete: true, edit: true }, visible.project );
    
    show.template = $.extend( { delete: true, backup: true, copy: true, edit: true }, visible.template );
    
    // cannot be overided
    show.media.copy = false;    
    
    target.open = function ( model ) {
        var type = model.resourceModel.type();
        if ( !show[type].edit && !show[type].settings ){
            return;
        }
        if ( type in links ) {
            var where = links[type].replace( "%5Bid%5D", model.id );
            location.href = where;
        }
    };
    target.create = function () {
        var type = model.resourceModel.type();
        if ( type in links ) {
            var where = links[type].replace( "%5Bid%5D", "" );
            location.href = where;
        }
    };
    target.copy = function ( model ) {
        var source = {
            name: spxapi.t("{name} - Copy", { "{name}": model.resourceModel.name() }),
            sourceId: model.id
        };
        spxapi[model.resourceModel.type()].create( source ).done( target.addMediaFile );     
    };
    target.backup = function ( model ) {
        var where = links['backup'].replace( "%5Bid%5D", model.id );
        location.href = where;        
    };
    target.canSelect = function ( rowData ) {
        var type = rowData.model.type();
        return type !== 'apps';
    } ;       
}
function WorkEdit( args ) {
    
    keywordsMemory( { reset: true } );
    args = args || {};
    
    var self = this;
    
    var openResource = function ( resource, id ){
        if ( !resource && args.newTemplateModal ) {
            args.newTemplateModal.modal('show');            
        } else {
            resource = resource || { type: 'playout', id: "" };
            var href = args.links[resource.type].replace( "%5Bid%5D", resource.id );
            location.href = href;
        }
    };
    
    self.create = function( ) {
        openResource();
    };
    self.selectAll = function( model, event ) {     
        var check = $(".spx-visible-check:visible");
        check.iCheck('check');        
    };
    self.unselectAll = function( model, event ) {     
        var check = $(".spx-visible-check:visible");
        check.iCheck('uncheck');        
    };
    
    self.backupResources = function( model, event ) {   
        var href;
        if ( self.resources.selected().length ){
            var selected = self.resources.selected();
            var ids = [];
            for ( var i=0; i<selected.length; i++ ){
                ids.push( selected[i].id );
            }
            href = args.links.backup.replace( "%5Bid%5D", JSON.stringify( ids ) );
        } else {
            href = args.links.backup.replace( "%5Bid%5D", "" );
        }
        loadButtonWithCheck( $(event.currentTarget) );
        location.href = href;        
        self.resources.selected.removeAll();
    };
    self.deleteResources = function( model, event ) {   
        var selected = self.resources.selected();
        for ( var i=0; i<selected.length; i++ ){
            selected[i].remove( selected[i], i !== selected.length-1 );
        }        
        loadButtonWithCheck( $(event.currentTarget) );
        self.resources.selected.removeAll();
    };
    self.createPlaylist = function( ) {   
        var href = args.links.playlist.replace( "%5Bid%5D", "" );
        location.href = href;
    };
    self.resources = resourcesSelect({
        resources: args.resources ,
        keepAllApps: args.keepAllApps,
        keepHidden: args.keepHidden,
        vertical: args.vertical,
        draggable : false,
        type: args.filter,
        viewId: 'create'
    });
    iconView( self.resources, { 
        draggable : false,         
        rows: 2 
    });
    addActions( self.resources, args.links, args.visible );
    
    if ( !args.noNewPlayout ) {
        self.newTemplate = resourcesSelect({
            viewId: "template",
            resources: [{
                name: spxapi.t("Empty playout"),
                keywords: ['default'],
                id: "horizontal",
                type: "playout",          
                model: spxapi.resources.add ( {
                    id: 'new playout horizontal',
                    icon: 'playout'
                })
            }, {
                name: spxapi.t("Empty playout"),
                keywords: ['default'],
                id: "vertical",
                type: "playout",          
                model: spxapi.resources.add ( {
                    id: 'new playout vertical',
                    icon: 'playout',
                    vertical: true
                })
            },
             'template' ]
        });    
        iconView( self.newTemplate, {
            onClick: function( item ){ 
                openResource( { type: item.type, id: item.id }, true );
            },
            showType: false,
            size: 'large',
            rows: 2,
            sizes: { v : { large : "col-sm-4"}}
        }); // need to be able to select it         
    }
    return self;
}
