<?php
class Diagnosis extends CFormModel {
	
    var $spxtest='spxtest';
    
    var $pid;
    var $tests = array();
    var $checks = array();
    var $outputs=array();
    
    var $setupok;
    var $status;
    var $nr_passed;
    var $nr_skipped;
    var $nr_failed;
    var $details;    
    
    var $fchecks;
    
    public function rules() {
		$res = array(
            array( "enablePowerSave, fixedMonPower", 'safe', 'on'=>'io, display, backup' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'enablePowerSave'=>'Enable display power saving',
   	    );
	}
    
    # get the list of available tests
    function get_config() {
        
        if ( PHP_OS == "WINNT" ) {
            $cmdret = file_exists("C:\srv\spxtest_L.txt")?0:1;
            $cmdout = explode("\n", file_get_contents("C:\srv\spxtest_L.txt") );
            
        } else  {
            exec( escapeshellarg($this->spxtest) . " -L", $cmdout, $cmdret);
        }
        
        if ($cmdret === 0) {
            $configstr = "";
            foreach ( $cmdout as $line) {
                $configstr .= $line . "\n";
            }
            $config = new DOMDocument;
            try {
                $ok = $config->loadXML( $configstr );
            } catch (Exception $e) {
                $this->addError('', 'Cannot parse config: '.$e->getMessage() );
            } 
            if ( !$ok ) {
                $this->addError('', 'Cannot parse config' );
                return;
            } 
            $main = $config->documentElement;            
            $this->tests = array();
            $this->checks = array();
            for ( $conf = $main->firstChild; $conf!=NULL; $conf = $conf->nextSibling ) {
        	    if ( $conf->nodeType!=XML_ELEMENT_NODE || $conf->localName!='test' )
				    continue;
                $test = array();
        	    for ( $item = $conf->firstChild; $item!=NULL; $item = $item->nextSibling ) {
                    if ( $item->nodeType!=XML_ELEMENT_NODE )
				        continue;
                    
                    if ( $item->localName!='check' )
                        $test[ $item->localName ] = $item->textContent;
                    else {
                        $check = array();
                        for ( $it2 = $item->firstChild; $it2!=NULL; $it2 = $it2->nextSibling ) {
                            if ( $item->nodeType!=XML_ELEMENT_NODE )
				                continue;
                            $check[ $it2->localName ] = $it2->textContent;
                        }
                        $check[ 'test' ] = $test[ 'name' ];
                        $this->checks[] = $check;
                        
                    }
                }
                $this->tests[] = $test;
            }
         }
    }
        
    # Runs the tests, skipping those which where selected for skip
    # in the submit form; returns FALSE on failure and the list of
    # checks to be completed by the operator otherwise. Also returns
    # the pid of the spxtest run
    function run_tests( )
    {
        $this->spxtest;

        syslog(LOG_NOTICE, "starting spxtest");

        # build the skip list
        $skips = array();
        foreach ($this->tests as $test) {
            $n = $test['name'];
            $fn = "test_" . $n;
            if ( isset($_POST[$fn]) && $_POST[$fn] === 'skip') {
                $skips[$n] = 1;
            }
        }

        # filter the list of checks by removing checks using skipped tests
        $this->fchecks = array();
        foreach ($this->checks as $check) {
            if ( ! array_key_exists($check['test'], $skips) )
                $this->fchecks[] = $check;
        }

        # build the command
        if ( PHP_OS == "WINNT" )
            $cmd = "C:\srv\spxtest.bat";
        else {
             $cmd = "exec " . escapeshellarg($this->spxtest) . " -p"; # always stop player
             foreach (array_keys($skips) as $s) {
                   $cmd .= ' -s ' . escapeshellarg($s);
             }
             $cmd .= ' 2>&1';
        }
        if ( PHP_OS == "WINNT" )
            $fdesc = array(
                        0 => array('file', 'C:\srv\spxtest_none.txt', 'r'),
                        1 => array('pipe', 'w'),
                        2 => array('file', 'C:\srv\spxtest_err.txt', 'w') 
                    );
        else
            $fdesc = array(
                        0 => array('file', '/dev/null', 'r'),
                        1 => array('pipe', 'w'),
                        2 => array('file', '/dev/null', 'w') 
                    );

        $eh = proc_open($cmd, $fdesc, $pipes, "/");
        if ($eh === FALSE) {
            $this->addError( "", "failed to start tests");
            return FALSE;
        }
        $sa = proc_get_status( $eh );
        $this->pid = $sa['pid'];
        
         
        unset($result);
        $this->details = array();
        $this->setupok = TRUE;
        while ( ! feof($pipes[1]) ) {
            $line = fgets($pipes[1]);
            if (preg_match('/^ALL TESTS RESULT:/', $line)) {
                $result = $line;
            } elseif (preg_match('/^TEST RESULT:\s+(\S+)\s+(\S+)/', $line, $matches)) {
                $this->details[] = array( 'name' => $matches[1], 'status' => $matches[2] );
                $result = $line;
            } elseif (preg_match('/^TEST (START|FINISH):\s+(\S+)/', $line, $matches)) {
                if ($matches[2] !== 'PASSED')
                    $this->setupok = FALSE;
            }
            $this->outputs[] = htmlspecialchars($line);
        }
        
        fclose($pipes[1]);
        $this->status = proc_close($eh);
        if ($this->status == -1) {
            $this->addError( "", "failed to get tests exit status");
            return FALSE;
        }
        if ( isset($result) ) {
            if (preg_match('/(\d+)\s+PASSED/', $result, $matches))
                $this->nr_passed = $matches[1];
            if (preg_match('/(\d+)\s+SKIPPED/', $result, $matches))
                $this->nr_skipped = $matches[1];
            if (preg_match('/(\d+)\s+FAILED/', $result, $matches))
                $this->nr_failed = $matches[1];
        } else {
            $this->addError( "", "result string not present");
            return FALSE;
        }
        if ( !isset($this->nr_passed) || !isset($this->nr_skipped) || !isset($this->nr_failed) ) {
            $this->addError( "", "cannot parse results");
            return FALSE;
        }
        return TRUE;
    }

    function save_feedback()
    {
    
        $this->pid = $_POST['pid'];
        
        syslog(LOG_NOTICE, "got operator results for spxtest pid " . ( ! empty($this->pid) ? $this->pid : 'unknown' ));

        if (isset($_POST['checks'])) {
            $nr_ok = 0;
            $nr_bad = 0;
            $nr_unknown = 0;
            $checks = preg_split('/\s+/', trim($_POST['checks']));
            foreach ($checks as $c) {
                $found = FALSE;
                foreach ($this->checks as $cd) {
                    if ($c === $cd['name']) {
                        $found = TRUE;
                        break;
                    }
                }
                if ( ! $found ) {
                    continue;
                }
                $res = $_POST['test_' . $c];
                $comm = $_POST['comm_' . $c];
                if ( isset($comm) )
                    $comm = preg_replace('/[\r\n]+/', ' ', trim($comm));
                if ( ! empty($res) ) {
                    $res_valid = TRUE;
                    switch ($res) {
                        case 'ok':
                            $nr_ok++;
                        break;
                        case 'bad':
                            $nr_bad++;
                        break;
                        case 'unknown':
                            $nr_unknown++;
                        break;
                        default:
                            syslog(LOG_NOTICE, "Invalid value for operator result on " . strtoupper($c));
                            $res_valid = FALSE;
                        break;
                    }
                    if ($res_valid)
                        syslog(LOG_NOTICE, "OPERATOR RESULT: " . strtoupper($c) . " " . strtoupper($res));
                }
                if ( ! empty($comm) ) {
                    syslog(LOG_NOTICE, "OPERATOR COMMENT: " . strtoupper($c) . ": " . $comm);
                }
            }
            syslog(LOG_NOTICE, "ALL OPERATOR RESULTS: $nr_ok OK $nr_bad BAD $nr_unknown UNKNOWN");
        }
        $comments = $_POST['comments'];
        if ( isset($comments) )
            $comments = preg_replace('/[\r\n]+/', ' ', trim($comments));
        if ( ! empty($comments) ) {
            syslog(LOG_NOTICE, "OPERATOR COMMENTS: " . $comments);
        }
        syslog(LOG_NOTICE, "done with operator results");
    }
  
    function start_tests() {
        # Start the test and show report form
        
        $this->get_config();
        return $this->run_tests( );
        
    }
    # process accordingly to request type
    function generate_report( ) {
        $this->get_config();
        # Save reported info and send a device report
        $this->save_feedback();
        # Return report
        $job = new Maintenance;
        $job->getReportFile( false );
    }

}