<?php
class Power extends CFormModel
{
    var $fixedMonPower = "no";
    var $onTime = "";
    var $offTime = "";

    var $sundayOn = "";
    var $sundayOff = "";
    var $mondayOn = "";
    var $mondayOff = "";
    var $tuesdayOn = "";
    var $tuesdayOff = "";
    var $wednesdayOn = "";
    var $wednesdayOff = "";
    var $thursdayOn = "";
    var $thursdayOff = "";
    var $fridayOn = "";
    var $fridayOff = "";
    var $saturdayOn = "";
    var $saturdayOff = "";

    var $powerSave = "true";

    var $modified = null;

    var $playerConf = null;

    public function rules()
    {
        $res = array(
            array("enablePowerSave", 'forceInt', 'on' => 'display, backup'),
            array("fixedMonPower", 'safe', 'on' => 'display, backup'),
            array(
                'onTime, offTime',
                'checkTime',
                'on' => 'display, backup',
                'fixedMonPower' => 'daily'
            ),
            array(
                'sundayOn, sundayOff, mondayOn, mondayOff, tuesdayOn, tuesdayOff, wednesdayOn, wednesdayOff, thursdayOn, thursdayOff, fridayOn, fridayOff, saturdayOn, saturdayOff',
                'checkTime',
                'on' => 'display, backup',
                'fixedMonPower' => 'weekly'
            ),
        );
        return $res;
    }
    public function attributeLabels()
    {
        return array(
            'enablePowerSave' => 'Enable display power management',
            'fixedMonPower' => 'Schedule',
            'onTime' => 'Turn monitor ON',
            'offTime' => 'Turn monitor OFF',
            'sundayOn' => 'Sunday ON',
            'sundayOff' => 'Sunday OFF',
            'mondayOn' => 'Monday ON',
            'mondayOff' => 'Monday OFF',
            'tuesdayOn' => 'Tuesday ON',
            'tuesdayOff' => 'Tuesday OFF',
            'wednesdayOn' => 'Wednesday ON',
            'wednesdayOff' => 'Wednesday OFF',
            'thursdayOn' => 'Thursday ON',
            'thursdayOff' => 'Thursday OFF',
            'fridayOn' => 'Friday ON',
            'fridayOff' => 'Friday OFF',
            'saturdayOn' => 'Saturday ON',
            'saturdayOff' => 'Saturday OFF',
        );
    }
    public function forceInt($attribute, $params)
    {
        if ($this->$attribute !== null) {
            $this->$attribute = intval($this->$attribute);
        }
    }
    public function checkTime($attribute, $params)
    {
        if ($this->$attribute == "") {
            return;
        }
        if ($this->scenario === 'backup' && $this->$attribute === "24:00") {
            return;
        }
        if ($this->scenario === 'display'
            && $this->fixedMonPower !== 'auto'
            && $this->fixedMonPower !== $params['fixedMonPower']) {
            return;
        }
        if (
            !preg_match(
                '/^([01]?[0-9]|2[0-3]):[0-5][0-9]$/',
                $this->$attribute
            )
        ) {
            $this->addError(
                $attribute,
                "Time format is HH:MM (between 00:00 and 23:59)"
            );
        }
    }
    function setEnablePowerSave($val)
    {
        if ($val) {
            $this->powerSave = "true";
        } else {
            $this->powerSave = "false";
        }
    }
    function getEnablePowerSave()
    {
        return $this->powerSave == "true";
    }
    public function getDays() {
        return array(
            "sunday",
            "monday",
            "tuesday",
            "wednesday",
            "thursday",
            "friday",
            "saturday",
        );
    }

    function setAttributes($inputs, $safeOnly = true)
    {
        if ($this->modified === null) {
            $this->load();
        }
        if (!is_array($inputs)) {
            return;
        }
        $attributes = array_flip(
            $safeOnly ? $this->getSafeAttributeNames() : $this->attributeNames()
        );
        foreach ($inputs as $name => $value) {
            if (isset($attributes[$name])) {
                if ($this->$name != $value) {
                    $this->modified = true;
                    $this->$name = $value;
                }
            } elseif ($safeOnly) {
                $this->onUnsafeAttribute($name, $value);
            }
        }
    }

    function load()
    {
        if ($this->playerConf === null) {
            $this->playerConf = new PlayerConfig();
        }
        if (!$this->playerConf->loadConfig()) {
            return false;
        }

        $domtree = $this->playerConf->domdoc;

        $ios = $domtree->getElementsByTagName("io");
        $this->fixedMonPower = "no";
        if ($ios->length > 0) {
            $io = $ios->item(0);
            if ($io->hasAttribute("onTime") && $io->hasAttribute("offTime")) {
                $this->onTime = $io->getAttribute("onTime");
                $this->offTime = $io->getAttribute("offTime");
                $this->fixedMonPower = "daily";
            }
            foreach ($this->days as $day) {
                $n = $day . "On";
                if ($io->hasAttribute($n)) {
                    $this->fixedMonPower = "weekly";
                    $this->$n = $io->getAttribute($n);
                }
                $n = $day . "Off";
                if ($io->hasAttribute($n)) {
                    $this->fixedMonPower = "weekly";
                    $this->$n = $io->getAttribute($n);
                }
            }
            if ($io->hasAttribute("enablePowerSave")) {
                $this->powerSave = $io->getAttribute("enablePowerSave");
            }
        } else {
            $this->powerSave = "false";
        }
        $this->modified = false;
    }

    function save()
    {
        if (!$this->modified) {
            return false;
        }

        if ($this->playerConf === null) {
            $this->playerConf = new PlayerConfig();
        }
        if (!$this->playerConf->loadConfig()) {
            return false;
        }
        $domtree = $this->playerConf->domdoc;

        $ios = $domtree->getElementsByTagName("io");
        if ($this->enablePowerSave) {
            if ($ios->length == 0) {
                $io = $domtree->createElement("io");
                $player = $domtree->documentElement->getElementsByTagName("player");
                if ($player->length > 0) {
                    $io = $player->item(0)->appendChild($io);
                } else {
                    $io = $domtree->documentElement->appendChild($io);
                    $this->addError(
                        "enablePowerSave",
                        "Warning no player tag found in the config, cannot add io tag."
                    );
                }
            } else {
                $io = $ios->item(0);
            }

            $io->removeAttribute("onTime");
            $io->removeAttribute("offTime");
            foreach ($this->days as $day) {
                $io->removeAttribute($day . "On");
                $io->removeAttribute($day . "Off");
            }

            if ($this->fixedMonPower === "auto") {
                $this->hasWeeklyOnOff($hasOn, $hasOff);
                if ($hasOn && $hasOff) {
                    $this->fixedMonPower = "weekly";
                } elseif ($this->onTime !== "" && $this->offTime !== "") {
                    $this->fixedMonPower = "daily";
                } else {
                    $this->fixedMonPower = "no";
                }
            }

            if ($this->fixedMonPower === "weekly") {
                foreach ($this->days as $day) {
                    $n = $day . "On";
                    if ($this->$n !== "") {
                        $io->setAttribute($n, $this->$n);
                    }

                    $n = $day . "Off";
                    if ($this->$n !== "") {
                        $io->setAttribute($n, $this->$n);
                    }
                }
            } else if ($this->fixedMonPower === "daily") {
                $io->setAttribute("onTime", $this->onTime);
                $io->setAttribute("offTime", $this->offTime);
            } 

            $io->setAttribute("enablePowerSave", $this->powerSave);
        } else {
            if ($ios->length) {
                $io = $ios->item(0);
                $io->parentNode->removeChild($io);
            }
        }

        if (!$this->hasErrors()) {
            $this->playerConf->saveConfig(true);
            return true;
        } else {
            return false;
        }
    }

    public function deleteSchedule() {
        $this->fixedMonPower = "auto";

        $this->onTime = "";
        $this->offTime = "";

        foreach ($this->days as $day) {
            $this->{$day . "On"} = "";
            $this->{$day . "Off"} = "";
        }
    }

    protected function afterValidate() {
        if ($this->scenario === 'display') {
            if ($this->fixedMonPower === "weekly") {
                $this->hasWeeklyOnOff($hasOn, $hasOff);
                if (!$hasOn) {
                    $this->addError('days', 
                        'At least one on time must be specified.');
                }
                if (!$hasOff) {
                    $this->addError('days', 
                        'At least one off time must be specified.');
                }
            } else if ($this->fixedMonPower === "daily") {
                if ($this->onTime === "") {
                    $this->addError('onTime', 'On time must be specified.');
                }
                if ($this->offTime === "") {
                    $this->addError('offTime', 'Off time must be specified.');
                }
            }
        }

        parent::afterValidate();
    }

    private function hasWeeklyOnOff(&$hasOn, &$hasOff) {
        $hasOn = false;
        $hasOff = false;
        foreach ($this->days as $day) {
            $n = $day . "On";
            if ($this->$n !== "") {
                $hasOn = true;
            }
            $n = $day . "Off";
            if ($this->$n !== "") {
                $hasOff = true;
            }
        }
    }
}
