<?php

class SecuritySettings extends CFormModel {

    protected $groups = array( 'admin', 'content', 'monitoring' );
    var $needreload = false;

    protected $map;
    public function init() {
        parent::init();
        $confbase = file_exists("/etc/apache2/conf.d") ?
            "/etc/apache2/conf.d/95-spxmanage-" :
            "/etc/apache/conf.d/95-raperca-";
        $this->map = array('content'   => $confbase . "cont-prot.conf",
                            'monitoring'=> $confbase . "log-prot.conf",
    		                'admin'     => $confbase . "adm-prot.conf");
    }
    public function rules() {
		return array(
            array('admin', 'safe' ),
            array('content', 'safe' ),
            array('monitoring', 'safe' ),
		);
	}

    public function attributeLabels()
	{
		return array(
            'admin'=>'Password protect RPC admin',
			'content'=>'Password protect content publishing',
            'monitoring'=>'Password protect monitoring',            
		);
	}
    public function __get($name)
    {
        if ( in_array( $name, $this->groups ) ){
            return $this->isProtected( $name );
        } else {
            return parent::__get($name);
        }
    }
    public function __set($name,$value)
    {
        if ( in_array( $name, $this->groups ) ){
            if( $value ){
                $this->setAccess( $name );
            } else {
                $this->clearAccess( $name );
            }
        } else {
            return parent::__set($name,$value);
        }
    }
    
    function getNeedreload() {
        return $this->needreload;
    }
    
    function reloadConfig() {
        if ($this->needreload) {
            Tools::reloadHttpd();
        }            
    }    
    
    
    function setAccess( $group ){
        
        if ( !isset($this->map[$group]) )
            return true;
        if ( $this->isProtected( $group ) )
            return true;
        
        $protfile = $this->map[$group];
        MaintenanceJobs::saveSymlink( basename($protfile).".tmpl", $protfile );
        $this->needreload = true;

        return true;
    }
    function clearAccess( $group ){

        if ( !isset($this->map[$group]) )
            return true;
        if ( !$this->isProtected( $group ) )
            return true;
            
        $protfile = $this->map[$group];
        
        if ( file_exists( $protfile ) ){
            unlink($protfile);
            exec('sync'); // make sure data is commited before returning
            $this->needreload = true;
        }

        return true;
    }
    
    function isProtected( $group ) {
        
        if ( isset($this->map[$group]) )
            return file_exists($this->map[$group]);
            
        return false;
    }
}
