<?php

class TemporaryFile {
    var $tmpName=null;
    var $extensionName;
    public function setFile( $filename ) {
        $this->tmpName = $filename;
        $this->extensionName = substr($filename, -3);
    }
    public function saveAs( $dest ){
        if ( $this->tmpName===null )
            return;
        if ( file_exists( $dest ) )
            unlink( $dest );
            
        copy( $this->tmpName, $dest );
    }
}

class SplashScreen extends CFormModel {
	
    protected $config = "/etc/default/splash";
    protected $defpath = "/usr/share/resources/default/splash";
    
    var $BOOTIMG = null;
    var $SHUTDOWNIMG = null;
    var $FIRMUPDIMG = null;
    
    var $BOOTIMG_link;
    var $SHUTDOWNIMG_link;
    var $FIRMUPDIMG_link;
    
    var $filepath = array();
    var $filenicename=array(
                            "BOOTIMG"=>"boot", 
                            "SHUTDOWNIMG"=>"shutdown", 
                            "FIRMUPDIMG"=>"firmware"
                        );
    var $fileslists=array(  
                            "BOOTIMG"=>"/etc/spinetix/splash/splash", 
                            "SHUTDOWNIMG"=>"/etc/spinetix/splash/shutdown", 
                            "FIRMUPDIMG"=>"/etc/spinetix/splash/fimrware-upd"
                        );
    
    public function rules() {
		$res = array(
            array( "BOOTIMG, SHUTDOWNIMG, FIRMUPDIMG", 'file', 'types'=>'jpg, png', 'maxSize'=>1024*1024 ,'allowEmpty'=>true, 'on'=>'setsplash' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'BOOTIMG'=>'Boot',
            'SHUTDOWNIMG'=>'Shutdown',
            'FIRMUPDIMG'=>'Firmware upgrade',
		);
	}
    function reset() {
        $dummy="";
        $ret=0;
        exec("/etc/spinetix/config.d/splash reset",$dummy,$ret);
	    if ($ret!=0) 
            $this->addError("", "Cannot reset the splash screens.");        
    }
    function load() {
        if ( !file_exists( $this->config ) )
            $this->reset();
        
        $logoconf = file_get_contents($this->config);
        
        foreach ($this->fileslists as $fn=>$dstfn ){
            if ( preg_match("/^\s*$fn=(.*)/m",$logoconf,$match)==1 ){
                $tmp = $match[1];
                
                if ( dirname($tmp)==$this->defpath ) $source="default";
                else $source="user";
                $file = basename($tmp);
                $n = $fn."_link";
                $this->$n="/showlogo.php?name=$file&source=$source";
                if ( $source=="user" )
                    $this->filepath[ $this->filenicename[$fn] ] = $tmp;
                else
                    $this->filepath[ $this->filenicename[$fn] ] = null;
            }
        }
        return $logoconf;
    }
    function addFile( $name, $source=null) {
        foreach ($this->filenicename as $dest=>$n )
            if ( $name==$n )
                break;
        
        if ( $source===null || !file_exists($source) )
            $this->$dest = true;
        else {
            $tmp = new TemporaryFile;
            $tmp->setFile( $source );
            $this->$dest = $tmp;
        }
    }
    function save() {
        $mustSave = false;
        
        $logoconf = $this->load();
        
        $logoconfdefault = file_get_contents( $this->config.".spxsave" );
        
        foreach ($this->fileslists as $fn=>$dstfn ){
            if ( $this->$fn===null ) continue;
            
            $n = $fn."_link";
            
            if ( $this->$fn===true ) {
                // reset to default
                if ( preg_match("/$fn=(.*)/", $logoconfdefault, $match) ){
                    $logoconf = preg_replace( "/$fn=.*/", $match[0], $logoconf ); 
                    
                    $file = basename( $match[1] );
                    $this->$n = "/showlogo.php?name=$file&source=default";
                } else
                    continue;
            } else {
                $dstName = $dstfn.".".strtolower($this->$fn->extensionName);
                
                $this->$fn->saveAs( $dstName );
                $logoconf = preg_replace("/$fn=.*/","$fn=$dstName",$logoconf);
                
                $file=basename($dstName);
                $this->$n="/showlogo.php?name=$file&source=user";
            }
            $mustSave = true;
        }
        
        if ($mustSave){
            file_put_contents( $this->config, $logoconf );
        }
    }

}

