<?php 


$this->beginWidget('SimpleForm', array( 
    'title' => "Device Self Test",
    'button' => "Start Test",
    'action' => array( 'post'=> array('run') )
)); 

echo CHtml::tag("p", array(), "Test started, please check the screen attached to the player for an indication of the progress of the testing procedure. " );

echo CHtml::tag("p", array(), "Select the tests that are to be run in the form below. The tests will be run in the order shown.");

echo CHtml::openTag("table", array( 'class'=>'table') );

echo CHtml::tag("thead", array(), CHtml::tag("tr", array(),  
                        CHtml::tag("th", array(), "Test") . 
                        CHtml::tag("th", array(),  "Run") . 
                        CHtml::tag("th", array(), "Skip") .
                        CHtml::tag("th" , array(), "Notes") 
              )) ;
$helps = array(); 
$cp=1;

foreach ( $diag->tests as $test ) {
    echo CHtml::openTag("tr");
    
    $name = htmlspecialchars("test_".$test['name']);
     
     echo Chtml::tag("td", array(  ), CHtml::label( $test['label'], $name ) );
     echo Chtml::tag("td", array(  ), CHtml::radioButton( $name, true, array( 'value'=>'run', 'class'=>'run' ) ) );
     echo Chtml::tag("td", array(  ), CHtml::radioButton( $name, false, array( 'value'=>'skip', 'class'=>'skip' ) ) );
     
    
    if ( isset( $test['help'] ) ){
        //echo CHtml::tag("tr", array(), CHtml::tag("td", array( 'colspan'=> 3 )) . CHtml::tag("td", array( 'colspan'=> 1 ), $test['help'] ) );
        echo CHtml::tag("td", array( 'class'=>'notes' ), "*[".$cp++."]");
        $helps[]=$test['help'];
    } else 
        echo CHtml::tag("td");

    echo CHtml::closeTag("tr");
}
echo CHtml::closeTag("table");

echo CHtml::tag("div", array( 'class'=>'pull-right' ), 
                          CHtml::link(  "[run all]", "#", 
                                        array( 'onclick'=>"$('.run').prop('checked',true); $('.skip').prop('checked',false);" )
                          ). "&nbsp;&nbsp;&nbsp;" .
                          CHtml::link(  "[skip all]", "#", 
                                        array( 'onclick'=>"$('.skip').prop('checked',true); $('.run').prop('checked',false);" )
                          ). "&nbsp;"
        );
echo CHtml::tag("br");

if ( count($helps)>0 ){
    echo CHtml::tag("h4", array(), "Notes");
    echo CHtml::openTag("ol");
    foreach ( $helps as $help) {
        echo CHtml::tag("li", array(), $help);
    } 
    echo CHtml::closeTag("ol");
}

$this->endWidget();

