<?php

/*
 * Automatic test
 */
include_once "Helpers.php";


class AppsTest extends CDbTestCase {
    
    public function checkListDesc( $desc, $data=null ){
        Helpers::checkAppsListDesc( $this, $desc, $data );        
    }
    
    public function checkDesc( $desc, $data=null ){
        Helpers::checkAppsDesc( $this, $desc, $data );
    }
    
    public function testCreate() {

        $data = Helpers::createApps( $this );
        $model = $data['model'];
        
        $this->checkListDesc( $model->listDesc, $data );
        $this->checkDesc( $model->desc, $data );        
        
        return $data;
    }
    
    /**
     * @depends testCreate
     */
    public function testGet( $data ) {
        
        $id = $data['id'];
        // verify that the resource has been created, by re-loading it from the db

        $model = Apps::model()->findByPk( $id );
        $this->assertNotSame( null, $model );
        $this->assertTrue($model instanceof Apps);
        
        $this->checkListDesc( $model->listDesc, $data );
        $this->checkDesc( $model->desc, $data );     
        
    }
    
    /**
     * @depends testCreate
     */
    public function testList( $data ) {
        
        $id = $data['id'];
        // verify that the resource has been created, by re-loading it from the db
        $models = Apps::model()->findAll();
        
        $this->assertTrue( is_array($models) );
        $this->assertTrue( count($models)>0 );
        $has_id = false;
        
        foreach ( $models as $model ){
            $this->assertTrue($model instanceof Apps);
            if ( $model->id==$id )
                $has_id = true;
            $this->checkDesc( $model->desc );        
            $this->checkListDesc( $model->listDesc );
        }
        $this->assertTrue( $has_id );
    }
    /**
     * @depends testCreate
     */
    public function testDelete( $data ) {
        
        $id = $data['id'];
        Helpers::removeApps( $this, $id, true );
        
        $model = Media::model()->findByPk( $id );
        $this->assertNull( $model );
        
    }    
    public function addTestCase( &$test, $v1, $v2=null, $v3=null ){
        $test[] = array( $v1, $v2, $v3);
    }
    public function fixMedia( &$media ){
        $mediaOptions = $media;
        $id = Helpers::createMedia( $this, "Media", $mediaOptions );
        $media = array(
            'id' => $id,
            'type' => 'media'
        );
        return $id;
    }
        
    public function genericTest( $widget = null, $data = null, $values = null, $success = true, $keep=false) {
        $toDetete = array();
        // need to create a sample apps
        $dataCheck = Helpers::createApps( $this, 'test', 'some desc', $widget, $data );        
        $id = $dataCheck['id'];
        unset( $dataCheck['model'] );
        if ( $values ){
            $this->assertNotNull( $data );
            $this->assertArrayHasKey( 'options', $data );
            $options = $data['options'];
            foreach ( $values as &$value ) {
                foreach( $value as $name => &$item ) {
                    if ( isset( $options[$name]) ){
                        $option = $options[$name];
                        if ( $option['type'] == 'media' ){
                            $toDetete[] = $this->fixMedia( $item );                            
                        } else if ( $option['type'] == 'playlist' ){
                            if ( isset($item['media']) ){
                                foreach( $item['media'] as &$media ) {
                                    $toDetete[] = $this->fixMedia( $media );                                    
                                }
                            }                            
                        }
                    }                    
                }
            }
            $model = Apps::model()->findByPk( $id );
            $this->assertNotSame( null, $model );
            $this->assertTrue($model instanceof Apps);
            $model->setValues( $values );
            if ( $success ) {
                $this->assertTrue( $model->save() );
                $dataCheck['data']['values'] = $values;                
            } else {
                $this->assertFalse( $model->save() );            
            }
        }
        if ( $success ) {
            // verify that the resource has been created, by re-loading it from the db
            $models = Apps::model()->findAll();

            $this->assertTrue( is_array($models) );
            $this->assertTrue( count($models)>0 );
            $has_id = false;
            foreach ( $models as $model ){
                $this->assertTrue($model instanceof Apps);
                $this->checkListDesc( $model->listDesc );

                if ( $model->id==$id ) {
                    //print_r($dataCheck);
                    $has_id = true;     
                    $this->checkDesc( $model->desc, $dataCheck );
                }

            }
            $this->assertTrue( $has_id, "Created apps ($id) not found in the list" );
        } 
        if ( $keep ) {
            $dataCheck['media'] = $toDetete;
            return $dataCheck;
        }
        Helpers::removeApps( $this, $id );
        foreach ( $toDetete as $id){
            Helpers::removeMedia($this, $id, true);
        }        
    }
    public function dataAppsProvider()
    {
        $test = array();
        $this->addTestCase( $test,
            array( 'max' => 10,
                   'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'string' ) 
            ) )
        );
        $this->addTestCase( $test,
            array( 'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'text' ) 
            ) )
        );
        $this->addTestCase( $test,
            array( 'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'number' ) 
            ) )
        );
        $this->addTestCase( $test,
            array( 'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'boolean' ) 
            ) )
        );
        $this->addTestCase( $test,
            array( 'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'color' ) 
            ) )
        );
        $this->addTestCase( $test,
            array( 'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'choice',
                                             'select' => array( array( 'value'=>'1') ,array( 'value'=>'2'),array( 'value'=>'3'))) 
            ) )
        );
        $this->addTestCase( $test,
            array( 'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'date' ) 
            ) )
        );
        $this->addTestCase( $test,
            array( 'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'time' ) 
            ) )
        );
        $this->addTestCase( $test,
            array( 'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'datetime' ) 
            ) )
        );
        return $test;
    }
    
    public function dataWidgetProvider(){
        $test = $this->dataAppsProvider();
        $this->addTestCase( $test,
            array( 'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'media' ) 
        ) ) );
        $this->addTestCase( $test,
            array( 'options' => array( 
                        'variable' => array( 'name' => 'Test', 'type' => 'playlist' ) 
        ) ) );
        return $test;
    }
    
    /**
     * @dataProvider dataAppsProvider
     **/
    public function testData( $data = null ) {
        $this->genericTest( null, $data );
    }
    /**
     * @dataProvider dataWidgetProvider
     **/
    public function testWidget( $data = null ) {
        $this->genericTest( array( $data ), null );
    }
    public function addValueTestCase( &$test, $values, $success, $max = 3 ){
        $setup = array( 
                'string' => array( 'name' => 'String', 'type' => 'string' ),
                'text' => array( 'name' => 'Text', 'type' => 'text' ), 
                'number' => array( 'name' => 'Number', 'type' => 'number' ), 
                'boolean' => array( 'name' => 'Bool', 'type' => 'boolean' ), 
                'color' => array( 'name' => 'Color', 'type' => 'color' ), 
                'choice' => array( 'name' => 'Choice', 'type' => 'choice',
                                   'select' => array( array( 'value'=>'1' ) , array( 'value'=>'2' ), array( 'value'=>'3' ) ) ), 
                'date' => array( 'name' => 'Data', 'type' => 'date' ), 
                'time' => array( 'name' => 'Time', 'type' => 'time' ), 
                'datetime' => array( 'name' => 'DT', 'type' => 'datetime' ), 
                'media' => array( 'name' => 'Media', 'type' => 'media' ), 
                'playlist' => array( 'name' => 'Playlist', 'type' => 'playlist' ), 
        );
        $options = array(
            'default' => array( 'name' => 'Default', 'type' => 'string' )
        );
        foreach( $values as $value) {
            foreach( $value as $name=>$item ) {
                if ( !isset( $options[$name]) && isset( $setup[$name] ))
                    $options[$name] = $setup[$name];
            }
        }
        $data = array( 
            'max' => $max,
            'options' => $options
        );
        $this->addTestCase( $test, $data, $values, $success );
    }
    public function stringValuesProvider()
    {   
        
        $test = array();
        $this->addValueTestCase( $test,
            array( 
                array( 'string' => "A" ),                 
            ),
            true
        );        
        $this->addValueTestCase( $test,
            array( 
                array( 'string' => "A" ), 
                array( 'string' => "B" ),
                array( 'string' => "C" ),
            ),
            true
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'string' => "A" ), 
                array( 'string' => "B" ),
                array( 'string' => "C" ),
                array( 'string' => "D" ),
            ),
            false
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'string' => "A\nB\nC" ), 
            ),
            false
        );
        return $test;
    }
    public function textValuesProvider()
    {        
        $test = array();
        $this->addValueTestCase( $test,
            array( 
                array( 'text' => "A" ),                 
            ),
            true
        );                
        $this->addValueTestCase( $test,
            array( 
                array( 'text' => "A\nB\nC" ), 
            ),
            true
        );
        return $test;
    }
    public function numberValuesProvider()
    {        
        $test = array();
        
        $rows = array();
        for ($i=0; $i<1000; $i++){
            $rows[] = array( 'number' => $i );   
        }
        $this->addValueTestCase( $test,
            $rows,
            true,
            1000
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'number' => "one" ),                 
            ),
            false
        );
        
        return $test;
    }
    public function booleanValuesProvider()
    {        
        $test = array();
        $this->addValueTestCase( $test,
            array( 
                array( 'boolean' => true ),                 
                array( 'boolean' => false ),                 
            ),
            true
        );  
        $this->addValueTestCase( $test,
            array( 
                array( 'boolean' => "true" ),                                 
            ),
            false
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'boolean' => "false" ),                                 
            ),
            false
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'boolean' => "text" ),
            ),
            false
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'boolean' => 7 ),
            ),
            false
        );
        return $test;
    }
    public function choiceValuesProvider()
    {        
        $test = array();
        $this->addValueTestCase( $test,
            array( 
                array( 'choice' => "1" ),
                array( 'choice' => "2" ),
                array( 'choice' => "3" ),                
            ),
            true
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'choice' => "A" ),
            ),
            false
        );
        return $test;
    }
    public function colorValuesProvider()
    {        
        $test = array();
        $this->addValueTestCase( $test,
            array( 
                array( 'color' => "#000000" ),                 
                array( 'color' => "#FFFFFF" ),                 
            ),
            true
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'color' => "hello" ),                 
            ),
            false
        );
        return $test;
    }
    public function dateValuesProvider()
    {        
        $test = array();
        $this->addValueTestCase( $test,
            array( 
                array( 'date' => "1973-01-13" ),                 
            ),
            true
        ); 
        $this->addValueTestCase( $test,
            array( 
                array( 'date' => "not a date" ),                 
            ),
            false
        ); 
        return $test;
    }
    public function timeValuesProvider()
    {        
        $test = array();
        $this->addValueTestCase( $test,
            array( 
                array( 'time' => "10:22:35" ),                 
                array( 'time' => "10:22" ),                 
            ),
            true
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'time' => "not a time" ),                 
            ),
            false
        );
        return $test;
    }
    public function datetimeValuesProvider()
    {        
        $test = array();
        $this->addValueTestCase( $test,
            array( 
                array( 'datetime' => "1973-01-13T11:22:00" ),
                array( 'datetime' => "1973-01-13T11:22" ),
            ),
            true
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'datetime' => "not a date" ),
            ),
            false
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'datetime' => "1973-01-13" ),
            ),
            false
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'datetime' => "11:22:00" ),
            ),
            false
        );
        return $test;
    }
    public function mediaValuesProvider()
    {        
        $test = array();
        
        $this->addValueTestCase( $test,
            array( 
                array( 'media' => null ),
                array( 'media' => null ),
                array( 'media' => null ),
            ),
            true
        );                        
        return $test;
    }
    public function playlistValuesProvider()
    {        
        $test = array();
        $this->addValueTestCase( $test,
            array( 
                array( 'playlist' => array(
                    'name => test'
                ) ),                 
            ),
            true
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'playlist' => array(
                    'name' => 'test',
                    'media' => array( //playlist with 3 default media
                        null, null, null
                    )
                ) ),                 
            ),
            true
        );
        return $test;
    }
    /**
     * @dataProvider stringValuesProvider
     **/
    public function testStringValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    /**
     * @dataProvider textValuesProvider
     **/
    public function testTextValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    /**
     * @dataProvider numberValuesProvider
     **/
    public function testNumberValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    /**
     * @dataProvider booleanValuesProvider
     **/
    public function testBooleanValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    /**
     * @dataProvider choiceValuesProvider
     **/
    public function testChoiceValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    /**
     * @dataProvider colorValuesProvider
     **/
    public function testColorValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    /**
     * @dataProvider dateValuesProvider
     **/
    public function testDateValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    /**
     * @dataProvider timeValuesProvider
     **/
    public function testTimeValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    /**
     * @dataProvider datetimeValuesProvider
     **/
    public function testDatetimeValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    /**
     * @dataProvider mediaValuesProvider
     **/
    public function testMediaValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    /**
     * @dataProvider playlistValuesProvider
     **/
    public function testPlayslistValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    
    public function valuesProvider()
    {        
        $test = array();
        
        $this->addValueTestCase( $test,
            array(                 
            ),
            true
        );
        $this->addValueTestCase( $test,
            array(   
                array( )
            ),
            true
        );
        $this->addValueTestCase( $test,
            array(   
                array( ),
                array( ),
            ),
            true
        );
        $this->addValueTestCase( $test,
            array(   
                array( ),
                array( ),
                array( ),
                array( ),
            ),
            false
        );
        $this->addValueTestCase( $test,
            array( 
                array( 'dummy' => true ),                 
            ),
            false
        );
        
        return $test;
    }
    /**
     * @dataProvider valuesProvider
     **/
    public function testValues( $data, $values, $success = true ) {
        $this->genericTest( null, $data, $values, $success );
    }
    
    public function dependencyProvider()
    {        
        $test = array();
        
        $this->addValueTestCase( $test,
            array( 
                array( 'media' => null ),
                array( 'media' => null ),
                array( 'media' => null ),
            ),
            true
        );                        
        $this->addValueTestCase( $test,
            array( 
                array( 'playlist' => array(
                    'name' => 'test',
                    'media' => array( //playlist with 3 default media
                        null, null, null
                    )
                ) ),                 
            ),
            true
        );
        return $test;
    }
    public function getMedia( $values ) {
        $media = array();
        foreach ($values as $value ){
            if ( isset($value['media'])){
                $media[] = $value['media'];
            } else if ( isset($value['playlist'])){
                $playlist = $value['playlist'];
                $this->assertArrayHasKey( 'media', $playlist );
                $media += $playlist['media'];
            } 
        }
        return $media;
    }
    /**
     * @dataProvider dependencyProvider
     **/
    public function testDependency( $data, $values, $success = true ) {
        $data = $this->genericTest( null, $data, $values, $success, true );
        $id = $data['id'];
        $toDetete = $data['media'];
        
        $this->assertSame( 3, count($toDetete) );

        while ( count( $toDetete )>0 ){
            $mediaId = array_pop($toDetete);
            
            $model = Apps::model()->findByPk( $id );
            $this->assertNotSame( null, $model );
            $this->assertTrue($model instanceof Apps);

            $media = $this->getMedia( $model->values );
            $this->assertTrue( count($media) > 0, "No media found");            
            $this->assertSame( count($toDetete) + 1, count($media) );
            
            $m = Media::model()->findByPk( $mediaId );
            $this->assertInstanceOf( 'Media', $m );
            Helpers::checkMediaParents( $this, $m->desc, $id );
            
            Helpers::removeMedia($this, $mediaId);

        }
        
        Helpers::removeApps( $this, $id );  
    }
}
