<?php
/*

  Copyright (c) 2014, SpinetiX S.A.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.

    * Neither the name of SpinetiX S.A. nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
  COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

*/

/**
 * Description of PullMode
 *
 * @author jr
 */
class PullMode {
    private $dest = "/var/spool/raperca/";
    private $actionName = "action";
    private $statusName = "status";
    
    public function checkEventFile( $uid ) {
        $name = null;        
        $dh = opendir( $this->dest );
        if ( $dh ) {
            while ( ($file = readdir($dh)) !== false ) {
                
                if ( strncmp( $file, $this->actionName, strlen($this->actionName) )==0 
                    || strncmp( $file, $this->statusName, strlen($this->statusName) )==0 ){
                    if ( strpos( $file, $uid )!==false ){
                        $name = $file;
                        break;
                    }
                }
            }
            closedir($dh);
        }
        return $name;
    }
    public function createEvent( $type, $uri, $max_retry = 3600, $options = null ) {
            
        $uid = uniqid("");
        
        $xmlns="http://www.spinetix.com/namespace/1.0/spxproj";
        $xlink="http://www.w3.org/1999/xlink";
        $now = time();
        
        
        // create the action struc
        
        $xml = new DOMDocument;
        $main = $xml->appendChild($xml->createElementNs($xmlns,'action') );
        $main->setAttribute("summary", $type );
        $main->setAttributeNs($xlink,"xlink:href", $uri);
        $main->setAttribute("time", $now );
        $main->setAttribute("end", $now + $max_retry );
        $main->setAttribute("guid",  $uid );
        
        if ( $options && is_array( $options ) ){
            foreach ($options as $option ) {
                $desc = $main->appendChild($xml->createElement('desc') );
                $desc->appendChild( $xml->createTextNode( $option ) );
            }
        }
        // check the folder to see if events exists
        $max = 0;
        $dh = opendir( $this->dest );
        if ( $dh ) {
            while ( ($file = readdir($dh)) !== false ) {
                
                if ( strncmp( $file, $this->actionName, strlen($this->actionName) )==0 ){
                    $n = intval( substr($file, strlen($this->actionName)+1,4 ), 10 );
                    if ( $n>=$max )
                        $max = $n+1;
                }
                
            }
            closedir($dh);
        }
        if ( $max<1000 && $max>99)
            $max = "0". $max;
        elseif ( $max<100 && $max>9)
            $max = "00". $max;
        else if ($max<10) 
            $max = "000". $max;
        
        file_put_contents( $this->dest.$this->actionName."-". $max ."-". $uid .".xml", $xml->saveXML() );
        
        if ( PHP_OS!='WINNT' ) {
            $pid = trim(file_get_contents('/var/run/uploader.pid'));
        
            posix_kill($pid, SIGUSR2);
        }
        return $now . "-" . $uid . "-0";
    }
    
    public function getStatus( $id ){
        $info = explode("-", $id );
        if ( count( $info )== 3 || count( $info )== 2 )
            $uid = $info[1];
        else
            $uid = $info[0];
        
        $file =  $this->checkEventFile( $uid );
        
        if ( $file===null ){
            $status = array( 
                'state' => 'notfound',
                'handle' => $id 
            );
            return $status;       
        } else if ( substr($file, strlen($file)-4 ) == "json" ){
            $status = @file_get_contents( $this->dest.$file );
            if ( empty( $status ) ){
                $status = array( 
                    'state' => 'notfound',
                    'handle' => $id 
                );
                return $status;
            }                
            return json_decode( $status, true );
        } else {
            // no json status, so the event is still queued but not processed
            $status = array( 
                'state' => 'queued',
                'handle' => $id 
            );
            return $status;
        }
    }
}
