<?php
/* @var $this MainController */

$this->breadcrumbs[] = $this->title = I18N::t('Playlist'); 

$this->registerSpxScript( 'resources.js' );


$this->beginWidget('AssetsList', array(
    'useDropZone' => false,
    'model' => 'playlistList',
    'resources' => "['playlist']"    
)); 
$this->endWidget();

$this->topBar .= $this->iconSet( array(
        array( 'icon'=> 'plus', 'title' => I18N::t('New Playlist'), 
                'data-bind' => 'click: create')
    ),
    array( 
        "class" => "pull-right"
    )
);

?>
<script type="text/javascript" >
//<![CDATA[
playlistList.editLinkTemplate = "<?php echo $this->createUrl("playlist/edit", array('id'=>"[id]") ); ?>";
playlistList.open = function ( model ) {
    var where = playlistList.editLinkTemplate.replace( "%5Bid%5D", model.id );
    location.href = where;
}
playlistList.create = function () {
    var where = playlistList.editLinkTemplate.replace( "%5Bid%5D", "" );;
    location.href = where;
};
playlistList.copy = function ( model ) {
    var source = {
        name: model.resourceModel.name() + " - Copy",
        sourceId: model.id
    };
    spxapi[model.resourceModel.type()].create( source ).done( playlistList.addMediaFile );   
    
};

ko.applyBindings( playlistList );

//]]></script>
