<?php
class ApplicationsAction extends CAction
{
    protected function interactivity(
        $playerConfig = null,
        $simpleFormId = "Interactivity"
    ) {
        if (!Yii::app()->branding->hasRight('interactivity')) {
            return array();
        }
        if (!$playerConfig) {
            $playerConfig = new PlayerConfig();
        }
        if ($simpleFormId == "Interactivity" && isset($_POST['PlayerConfig'])) {
            $playerConfig->setScenario('inter');
            $playerConfig->setAttributes($_POST['PlayerConfig']);
            if ($playerConfig->validate()) {
                $playerConfig->saveConfig();
            }
        }
        return array(
            'playerConfig' => $playerConfig,
        );
    }

    protected function touchscreen()
    {
        if (!Yii::app()->branding->hasRight('interactivity')) {
            return array();
        }
        $touchCalibration = new TouchCalibration();

        if (isset($_POST['TouchCalibration'])) {
            $touchCalibration->setScenario('config');
            $touchCalibration->setAttributes($_POST['TouchCalibration']);
            if ($touchCalibration->validate()) {
                $touchCalibration->save();
            }
        } else {
            $touchCalibration->load();
        }
        return array(
            'touchCalibration' => $touchCalibration,
        );
    }

    protected function sv($playerConfig = null, $simpleFormId = "SV")
    {
        if (!Yii::app()->branding->hasRight('netAPI')) {
            return array();
        }
        if (!$playerConfig) {
            $playerConfig = new PlayerConfig();
        }
        if ($simpleFormId == "SV" && isset($_POST['PlayerConfig'])) {
            $playerConfig->setScenario('netapi');
            $playerConfig->setAttributes($_POST['PlayerConfig']);
            if ($playerConfig->validate()) {
                $playerConfig->saveConfig();
            }
        }
        return array('playerConfig' => $playerConfig);
    }
    protected function webstorageAPI()
    {
        $webstorageAPI = new WebstorageAPIConfig();

        if (isset($_POST['WebstorageAPIConfig'])) {
            $webstorageAPI->setAttributes($_POST['WebstorageAPIConfig']);
            $webstorageAPI->save();
        } else {
            $webstorageAPI->load();
        }
        return array(
            'webstorageAPI' => $webstorageAPI,
        );
    }
    protected function securityRPC()
    {
        $securityRPC = new SecurityRPC();

        if (isset($_POST['SecurityRPC'])) {
            $securityRPC->setAttributes($_POST['SecurityRPC']);
            $securityRPC->save();
        } else {
            $securityRPC->load();
        }
        return array(
            'securityRPC' => $securityRPC,
        );
    }
    static function multiscreen(
        $playerConfig = null,
        $simpleFormId = "Multiscreen"
    ) {
        if (!Yii::app()->branding->hasRight('multiscreen')) {
            return array();
        }
        if (!$playerConfig) {
            $playerConfig = new PlayerConfig();
        }
        if ($simpleFormId == "Multiscreen" && isset($_POST['PlayerConfig'])) {
            $playerConfig->setScenario('id');
            $playerConfig->setAttributes($_POST['PlayerConfig']);
            if ($playerConfig->validate()) {
                $playerConfig->saveConfig();
            }
        }
        return array('playerConfig' => $playerConfig);
    }

    static function firmware()
    {
        if (!Yii::app()->branding->hasRight('firmware')) {
            return array();
        }
        $firmwareUpdate = new FirmwareUpdate();
        $firmwareUpdate->load();

        if (isset($_POST['FirmwareUpdate'])) {
            $firmwareUpdate->setScenario('all');
            $firmwareUpdate->setAttributes($_POST['FirmwareUpdate']);
            if ($firmwareUpdate->validate()) {
                $firmwareUpdate->save();
            }
        }

        return array(
            'firmwareUpdate' => $firmwareUpdate,
        );
    }

    static function concentrator()
    {
        if (!Yii::app()->branding->hasRight('pullMode')) {
            return array();
        }
        $pullModeConfig = new PullModeConfig();
        $pullModeConfig->load();

        if (isset($_POST['PullModeConfig'])) {
            if (isset($_POST['PullModeConfig']['selectMode'])) {
                $mode = $_POST['PullModeConfig']['selectMode'];
            } else {
                $mode = PullModeConfig::PULL_STATIC;
            }
            $pullModeConfig->setSelectMode($mode);
            $pullModeConfig->setAttributes($_POST['PullModeConfig']);
            if ($pullModeConfig->validate()) {
                $pullModeConfig->save();
            }
        }

        return array(
            'pullModeConfig' => $pullModeConfig,
        );
    }

    protected static function streaming()
    {
        if (!Yii::app()->branding->hasRight('IPTV')) {
            return array();
        }        
        $applicationsStreaming = new ApplicationsStreaming();
        $applicationsStreaming->load();
        if (isset($_POST['ApplicationsStreaming'])) {
            if ($applicationsStreaming->setAttributes(
                $_POST['ApplicationsStreaming'])) {
                $applicationsStreaming->save();
            }
        }
        $streaming = new Streaming();
        $streaming->load();
        return array(
            'streaming' => $applicationsStreaming,
            'hasXML' => !!$streaming->getXML(),
        );
    }

    protected static function webRtc(
        $playerConfig = null,
        $simpleFormId = "WebRTC"
    ) {
        if (!Yii::app()->branding->hasRight('webRtc')) {
            return array();
        }
        if (!$playerConfig) {
            $playerConfig = new PlayerConfig();
        }
        if ($simpleFormId == "WebRTC" && isset($_POST['PlayerConfig'])) {
            $playerConfig->setScenario('WebRTC');
            $playerConfig->setAttributes($_POST['PlayerConfig']);
            if ($playerConfig->validate()) {
                $playerConfig->saveConfig();
            }
        }
        return array(
            'playerConfig' => $playerConfig,
        );
    }

    public function run()
    {
        $simpleFormId = isset($_POST['SimpleFormId'])
            ? $_POST['SimpleFormId']
            : "";

        $playerConfig = new PlayerConfig();

        $options = array(
            'basicInfo' => new BasicInfo(),
        );

        $options += self::interactivity($playerConfig, $simpleFormId);
        $options += self::touchscreen();

        $options += self::sv($playerConfig, $simpleFormId);
        $options += self::multiscreen($playerConfig, $simpleFormId);
        $options += self::securityRPC();
        $options += self::webstorageAPI();
        $options += self::firmware();
        $options += self::concentrator();
        $options += self::streaming();
        $options += self::webRtc($playerConfig, $simpleFormId);

        $this->controller->render('applications', $options);
    }
}
