<?php
/* @var $this ConfigController */

$formConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "Network API",
    'id' => "SV",
    'button' => "Apply",
    'action' => array ( 'post' => array() )
) );
    $formConfig->errorSummary( $playerConfig );
    $configBackup = New ConfigBackup;
    /*
    echo $formConfig->activeSwitch( $playerConfig, "NetAPIEnabled", array(
        "data-bind" => "checked: NetAPIEnabled"
    ) );
    */  
    

    echo $formConfig->activeCheckBox( $playerConfig, "NetAPIEnabled", array(), true );
    echo CHtml::openTag("div", array( 'data-bind' => 'visible: NetAPIEnabled') );
        
        echo $formConfig->activeCheckBox( $playerConfig, "LegacyNetAPIEnabled", array( 
            "data-bind" => "enable: NetAPIEnabled"
        ), true );
        echo CHtml::openTag("div", array( 'data-bind' => 'visible: LegacyNetAPIEnabled') );
            echo $formConfig->activeTextField( $playerConfig, "sharedVarPort", array(
                    "data-bind" => "enable: LegacyNetAPIEnabled"
            ) );
        echo CHtml::closeTag("div");  
        if ( $playerConfig->NetAPIEnabled ){ 
            $this->widget( 'DialogButton' , array(
                'label' => "Generate Client Config",
                'script' => "yiiClientConfigWizard.show();",
                'level' => BsHtml::ALERT_COLOR_INFO,
                'content' => false
            ));
        }
    echo CHtml::closeTag("div");  

    $this->widget( 'DialogButton' , array(
        'label' => "Upload Client Config",
        'args' => CJavaScript::encode( array(
            'url' => CHtml::normalizeUrl( array( "backup/post" ) ),
            'dropZone' => "js:$('#SV')"
         )), 
        'file' => CHtml::activeName( $configBackup, 'uploadedfile' ),
        'content' => false
    ));

    echo $formConfig->activeTextField( $playerConfig, "sharedVarDefaultServer" );

$this->endWidget();


$infoStep = CHtml::tag("p", array( 'class' => 'col-sm-12'), 
    "This wizard will generate a file to configure clients of this Network API secure server. ".
    "It will automatically configure the credentials, the default Network API server address and optionally set this player as the time server. "
);
$infoStep .= CHtml::tag("p", array( 'class' => 'col-sm-12'), 
    "You will need to save the generated configuration file and upload it to all clients. "
);
ob_start(); 
$ntpConfig = $this->beginWidget('SimpleForm', array( 
        'nbBox' => null,
        'labelSize' => 10,
        'inputSize' => 2,
        'formClass' => ""
) );
    echo $ntpConfig->activeCheckBox( $configBackup, "backupNTP", array(), true );      
    echo CHtml::tag("div", array( 'data-bind' => 'visible: backupNTP()', 'class' => 'col-sm-12'), 
                "The NTP settings of the client will be updated to use this player as the time master. "
    );
$this->endWidget();
$ntpStep = ob_get_contents ( );
ob_end_clean();

$location = CHtml::normalizeUrl( array("backup/getClientConfig") );
$submit = <<<JSSCRIPT
function( wizard ) {
    console.log( yiiModel.backupNTP() );
    wizard.submitSuccess();
    wizard.close();
    wizard.hideButtons();
    wizard.updateProgressBar(0);    
    wizard.reset();

    window.location = "$location?ntp=" + yiiModel.backupNTP();
} 
JSSCRIPT;

$this->widget('SPXWizard', array(
    'wizardName' => 'yiiClientConfigWizard',
    'title' => "Client Configuration File",    
    'pages' => array(        
        array(  'title'=> 'Info', 
                'content'=> $infoStep
        ),            
        array(  'title'=> 'NTP', 
                'content'=> $ntpStep
        ),
        array(  'title'=> 'Download', 
                'content'=>  CHtml::tag("p", array(), "Save the generated configuration file and upload it to all clients.") . 
                CHtml::tag("p", array(), "This file contains authentication credentials. Keep it secure!" )
        ),
    ),    
    'failure' => "An error occurred while getting the configuration. Please reload the page and start setup again.",
    'options' => array(
        'formClass' => 'xxx',
        'show' => false,
        'contentHeight' => 280,
        'contentWidth' => 650,
        'buttons'=> array( 'submitText' => 'Download' )
    ),     
    'submit' => $submit
) );
?>
<script type="text/javascript" >
//<![CDATA[
    function clientConfigFailFunction( jqXHR, textStatus, errorThrown ){
        //console.log(errorThrown);
        yiiModel.addErrors( [ errorThrown] );
    }
//]]></script>