<?php

/*
 * Automatic test
 */
include_once "Helpers.php";


class ResourceTest extends CDbTestCase {
    
    public function checkDesc( $desc, $data ){
        $this->assertArrayHasKey( 'id', $desc );
        $name = "\nid: ".$desc['id'];
        
        $this->assertArrayHasKey( 'name', $desc );
        
        Helpers::checkKeywords( $this, $desc, $data, $name );
        
        $this->assertArrayHasKey( 'type', $desc );
        $this->assertArrayHasKey( 'manage', $desc );
        $this->assertEquals($data['id'], $desc['id'] );
        $this->assertEquals($data['name'], $desc['name'] );
        $this->assertEquals($data['type'], $desc['type'] );
        $this->assertEquals(
                GlobalSettings::$uriBase.$data['type']."/".$data['id']."/", 
                $desc['manage'] );
    }

    public function testCreate() {
        $resource = New Resource;
        
        $data = array (
            'name' => 'test',
            'type' => 'media',
            'keywords' => array( 'test', 'auto' )
        );
        $resource->attributes = $data;
        
        $this->assertTrue( $resource->save() );
        $id = $resource->id;
        
        $this->assertNotNull( $id );
        $data['id'] = $id;        
        
        // check that the folder exist 
        $this->assertTrue( file_exists( $resource->folder ) );
        
        $this->checkDesc( $resource->desc, $data );        
        $this->checkDesc( $resource->listDesc, $data );
        
        return $data;
    }
    
    /**
     * @depends testCreate
     */
    public function testGet( $data ) {
        
        $id = $data['id'];
        // verify that the resource has been created, by re-loading it from the db

        $resource = Resource::model()->findByPk( $id );
        $this->assertNotSame( null, $resource );
        $this->assertTrue($resource instanceof Resource);
        
        $this->assertEquals($data['name'], $resource->name );
        $this->assertEquals($data['type'], $resource->type );
        
        $this->checkDesc( $resource->desc, $data );        
        $this->checkDesc( $resource->listDesc, $data );
        
    }
    
    /**
     * @depends testCreate
     */
    public function testList( $data ) {
        
        $id = $data['id'];
        // verify that the resource has been created, by re-loading it from the db
        $resources = Resource::model()->findAll();
        
        $this->assertTrue( is_array($resources) );
        $this->assertTrue( count($resources)>0 );
        
        $has_id = false;
        foreach ( $resources as $resource ){
            $this->assertTrue($resource instanceof Resource);
            if ( $resource->id==$id )
                $has_id = true;
        }
        $this->assertTrue( $has_id );
    }
    /**
     * @depends testCreate
     */
    public function testDelete( $data ) {
        
        $id = $data['id'];
        $resource = Resource::model()->findByPk( $id );
        
        $this->assertTrue( $resource->delete() );
        
        $new_resource = Resource::model()->findByPk( $id );
        $this->assertNull( $new_resource );
        
        $this->assertFalse( file_exists( $resource->folder ) );
    }
    
    public function createErrorsProvider()
    {
        return array(
            array( null, null, null, false ),
            array( "name", null, null, false ),
            array( null, null, "media", false ),
            array( "name", null, "dummy", false ),  
            
            array( "name", null, "media", true ),
            array( "name", null, "playlist", true ),
            
            array( "utf8ä中企", null, "media", true ),
            array( "space []", null, "media", true ),
            array( "/test/dummy", null, "media", true ),
            
            array( "utf8ä中企", Array('test','ä中企', 'utf8'), "media", true ),
            );
    }
    /**
     * @dataProvider createErrorsProvider
     * @depends testDelete
     */
    public function testCreateErrors( $name, $keywords, $type, $success ) {
        $resource = New Resource;
        
        $data = array (
            'name' => $name,
            'keywords' => $keywords?$keywords:array( ),
            'type' => $type
        );
        $resource->attributes = $data;
        if ( $success ){
            $this->assertTrue( $resource->save() );        
            $this->assertFalse( $resource->hasErrors() );
            
            $data['id'] = $resource->id;
            $this->checkDesc( $resource->desc, $data );        
            $this->checkDesc( $resource->listDesc, $data );
        
            $this->assertTrue( $resource->delete() );
        } else {
            $this->assertFalse( $resource->save() );        
            $this->assertTrue ( $resource->hasErrors() );
        }
    }
}
