<?php


$this->registerSpxScript( 'basemodel.js' );
$this->registerSpxScript( 'firmware.js' );


$config = array(
    'bootId' => Tools::getBootID(),
    'urlReboot' => CHtml::normalizeUrl( array("/controlcenter/operation/reboot", 'reboot'=>true, ) ),
    'bootNow' => Tools::checkReboot(),
    'instalMode' => Tools::checkInstallationmode(),
    'pendingChangeList' => Tools::getPendingChangeList(),
    'addMessages' => Tools::getMessages(),
    'csrfTokenName' => Yii::app()->request->csrfTokenName,
    'csrfToken' =>
        "js:'" . CJavaScript::quote(Yii::app()->request->csrfToken) . "'"
); 
$configFirmware = array(
    'urlNetCheck' => CHtml::normalizeUrl(array("/controlcenter/operation/checkNetwork")),
    'handle' => $handle,
    'infoTarget' => "#FirmwareInfo",
    'source' => $source
);
if ( Updater::isUpdateInProgress() && !$configFirmware['handle'] ){
    $configFirmware['handle'] = true;
}

echo CHtml::script( $this->localScript )."\n";   

if ( $configFirmware['handle'] ){
    $this->beginWidget('bootstrap.widgets.BsPanel', array(
        'title' => 'Updating Firmware'    
    ));

        echo CHtml::tag( "div", array( "id" => "FirmwareInfo") , "" );
        echo CHtml::tag( "div", array( "id" => "Running", "style" => "text-align: center;"),
                CHtml::tag( "i", array( "class" => "fa fa-circle-o-notch fa-spin fa-4x" ), "" )
            );
        if ( !Yii::app()->user->getIsGuest() ){
            $this->widget('SimpleForm', array( 
                'nbBox' => false,
                'title' => "Logs",
                'hide' => true,
                'desc' => CHtml::tag("pre", array( 'data-bind'=>'foreach: firmwareStatus().logs' ),
                    "<!-- ko text: \$data + \"\\n\" --><!-- /ko -->")
            ) );
        }
        //echo CHtml::tag( "div" , array( 'data-bind' => 'text: ko.toJSON(firmwareStatus)' ), " ");

    $this->endWidget();
} else {
    // no firmware updates are running
    $firmwareUpdate = new FirmwareUpdate;
    $firmwareUpdate->load();
    $formUpdate = $this->beginWidget('SimpleForm', array( 
        'title' => "Firmware Update is not running",        
    ) );
        $info = $formUpdate->activeItemValue( $firmwareUpdate, "firmwareVersionLong" );
        $info .= $formUpdate->activeItemValue( $firmwareUpdate, "updaterVersionLong" );
        if ( $firmwareUpdate->spxjslibsVersion!==false ) {
            $info .= $formUpdate->activeItemValue( $firmwareUpdate, "spxjslibsVersionLong" );
        }
        
        echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO, $info, array( 'closeText' => false ) );
    $this->endWidget();
}   
?>
<script type="text/javascript" >
//<![CDATA[
$(function() {
    extendModelExt( yiiModel, [], <?php echo CJavaScript::encode( $config ); ?> );
    extendModelFirmware( yiiModel, <?php echo CJavaScript::encode( $configFirmware ); ?> );

    ko.applyBindings( yiiModel );
    
    yiiModel.firmwareStatus.subscribe( function( newValue ) {    
        if ( newValue.running ){
            $('#Running').show();
            $('#head-nav').hide();
        } else {
            $('#Running').hide();            
        }
        if ( !newValue.started && !newValue.success ){
            $('#head-nav').show();
        }
    });
    yiiModel.reboot.subscribe( function( newValue ) {
        if ( newValue ){
            $('#head-nav').hide();
        } else {
            $('#rebootMsg').text("Restarted sucessfully, you can now use the device.");
            $('#head-nav').show();
        }
    });    
<?php 
    if ( Yii::app()->user->getIsGuest() ){
        echo "setTimeout( function() { location.reload();},30*1000 );\n$('#head-nav').hide();\n";
    }
?>
});
//]]></script>
