<?php
/* @var $this MainController */

$this->breadcrumbs[] = $this->title = 'Apps'; 

?>
<div class="row clearfix">
    <table class="no-border table" data-bind="dataTable: datatableOptions">
        <thead class="no-border">
        </thead>
        <tbody class="no-border-y">            
        </tbody>            
    </table>
</div>
<script type="text/javascript" >
//<![CDATA[
function AppsList() {
    var self = this;
    self.datatableOptions = {
        ajax: {
            url: spxapi.apps.uri,
            dataSrc: ""
        },
        order : [[1, "asc"] ],
        lengthMenu: [ 4, 12, 24 ],
        columns: [
            {   title: "", 
                data : "icon", orderable : false,
                createdCell: function (td, cellData, rowData, row, col) {
                    $(td).html("<img class='icon' src='"+cellData+"'/>");
                } 
            },
            {   title: "Name", 
                data : "name" },
            {   title: "Description", 
                data : "desc" },
            {   title: "Keywords", 
                data : "keywords[, ]" },
            {   title: "", 
                data : "uri", orderable : false,
                createdCell: function (td, cellData, rowData, row, col) {
                    if ( cellData === null )
                        $(td).html("");
                    else
                        $(td).html(spxapi.ui.iconAction( { link: cellData, type: 'edit' } ) );
                }
            }            
        ]
    };
    return self;
}
ko.applyBindings( new AppsList() );

//]]></script>