
var Apps2 = function( args ) {
    var self = { };
    var appskeys = null;
    function getQuery( query, preview ) {
        query = query || {};
        
        var props = self.properties();  
        for ( var i=0; i<props.length; i++ ){
            if ( props[i].queryId && props[i].value() !== undefined && props[i].value() !== "" ){
                if ( props[i].type === 'boolean' ) {
                    query[props[i].queryId] = props[i].value() === true || props[i].value() === "true";
                } else if ( props[i].type === 'slider' || props[i].type === 'number' ) {
                    query[props[i].queryId] = parseFloat( props[i].value() ) || 0;
                } else {
                    query[props[i].queryId] = props[i].value();
                }
                if ( preview && 'previews' in props[i] && query[props[i].queryId] in props[i].previews ){
                    query[props[i].queryId] = props[i].previews[query[props[i].queryId]];
                }
            }
            
            if ( props[i].type === 'color_opacity' && props[i].opacity.value() !== undefined ){
                query[props[i].opacity.queryId] = props[i].opacity.value();
            }
        }
        return query;
    }
    function updateProperties( query ) {
        var queryId, prop, i;
        query = getQuery( query, true );
        if ( self.properties().length > 1 ) {            
            // clear all properties except the first one
            self.properties.splice( 1, self.properties().length-1);
            self.uiProperties.removeAll();
        }
        var widget = self.widgets[ self.widgetId() ];
        var lastProp = {};
        var opacityCheck = new RegExp(/opacity/i);        
        for ( queryId in widget.options ) {            
            prop = $.extend( {}, widget.options[queryId] );
            prop.name = spxapi.t( prop.name, null, appskeys );
            var val = query[queryId];
            if ( val === undefined && (prop.type === "choice" || prop.type === "boolean") && prop.default !== undefined ){
                val = prop.default;
            }
            if ( val === undefined && prop.type === "locales" ){
                val = "en_US";
            }
            if ( prop.type === "choice" && $.isArray( prop.select ) ){
                for ( i=0; i< prop.select.length; i++ ){
                    if ( 'name' in prop.select[i] ){
                        prop.select[i].name = spxapi.t(prop.select[i].name, null, appskeys);
                    }
                    if ( 'preview' in prop.select[i] ){
                        if ( ! ('previews' in prop) ){
                            prop.previews = {};
                        }
                        prop.previews[prop.select[i].value] = prop.select[i].preview;
                    }
                }
            }
            if ( queryId === 'variable' ) {                
                if ( val === undefined ){
                    val = btoa(self.id + "." + Date.now());
                }                
                prop.value = self.variable;
                self.variable( val );
            } else {
                prop.value = ko.observable( val )
                           .extend({ rateLimit: { timeout: 500, method: "notifyWhenChangesStop" } }); 
            }
            prop.queryId = queryId;
            if ( opacityCheck.test(queryId) && lastProp.type === 'color' ){
                lastProp.type = 'color_opacity';
                lastProp.opacity = prop;
            } else {
                self.properties.push( prop );
                if ( prop.ui ) {
                    self.uiProperties.push( prop );
                }
            }
            lastProp = prop;
        }
        if ( self.editLink ){               
            self.uiProperties.push( {
                type: "link",
                name: spxapi.t( "Edit link" ),
                value: ko.computed( function() {
                    var link = self.editLink;
                    if ( self.variable() ){
                        if ( link.indexOf("?")>0 ){
                            link += "&";
                        } else {
                            link += "?";
                        }
                        link += "sv=" + self.variable();
                    }
                    return link;
                })
            } );
        }        
    }
    self.fromJS = function( data ) {
        var name, widgetId, widget;
        
        self.type = data.type;
        self.id = data.id;
        
        self.widgetId = ko.observable( data.widgetId );
        
        appskeys = data.apps.i18n;
        
        self.manage = data.apps.manage;
        self.name = data.apps.name;
        self.desc = data.apps.desc;
        self.widgets = data.apps.widgets;
        self.editLink = data.apps.editLink;
        self.variable = ko.observable();
        self.variable.subscribe(function(newValue) {
            if ( newValue ){
                spxapi.rpc.variable_get( newValue, function( value ){
                    spxapi.storage.set( newValue, ko.toJSON( value ), 
                    spxapi.t('Cannot set variable to localStorage, preview of apps is not available. A possible cause of this error is the use Private browsing windows.') );               
                });
            }
        });
        self.properties = ko.observableArray( [] )
                            .extend({ rateLimit: 0 });
        self.uiProperties = ko.observableArray( [] )
                            .extend({ rateLimit: 0 });
        
        // let the user select wich one of the widget he is going to use for the apps
        var prop = { name: spxapi.t( 'Type' ), type : 'choice', value: self.widgetId, select: [] };
        for ( widgetId in self.widgets ) {
            widget = self.widgets[widgetId];
            if ( !args.widgetType || !widget.type || args.widgetType === widget.type ){
                prop.select.push( {
                    name: spxapi.t(widget.name, null, appskeys),
                    value: widgetId
                });
            }
        }
        if ( prop.select.length > 1 ){
            self.properties.push( prop );
        }
        updateProperties( data.query );
        self.widgetId.subscribe( function () {
            updateProperties();
        });
        
        self.preview = ko.computed( function() {
            var query = getQuery( {}, true );
            
            var queryString = "";
            var s = "?";
            for ( name in query ){
                queryString += s + encodeURIComponent( name ) 
                            + "=" 
                            + encodeURIComponent( query[name] );
                s = "&";                
            } 
            queryString += s + "_=" + Math.random();
            //console.log( queryString );
            return self.widgets[ self.widgetId() ].preview + queryString;
        });        
    };
    self.toJS = function(){
        var data = {
            id: self.id,
            widgetId: self.widgetId(),
            query: getQuery( )
        };
        return data;
    };
    self.toJSON = function(){
        return JSON.stringify( self.toJS() );
    };
    
    self.cleanup = function () {
        var variable = self.variable();
        if ( variable ) {
            spxapi.rpc.variable_remove( variable );
            spxapi.storage.remove( variable );               
        }
    };
    self.fromJS( args );
    return self;
};

function AppsEdit( args ) {
    var self = {
        id: args.id,
        manage: args.manage,
        variable: args.variable,
        name: ko.observable( args.name ),
        desc: ko.observable( args.description ),
        data: null,
        showParent: ko.observable( true )
    };
    var context = args.i18n;
    self.t = function ( txt, args ){
        return spxapi.t(txt, args, context );
    }
    self.toJS = function( ){
        return ko.mapping.toJS( self.data );
    };
    self.fromJS = function( value ){
        if ( self.data ){
            ko.mapping.fromJS( value, self.data );
        } else {
            self.data = ko.mapping.fromJS( value );
        }
    };
    function updateLocalStorage( params ) {
        spxapi.storage.set( self.variable, ko.toJSON( params ) );
    }
    
    self.load = function (){
        spxapi.rpc.variable_get( self.variable, function( value ){
            if ( value ) {
                updateLocalStorage( value );
                self.fromJS( value );
            }
        });
        
            
    };
    
    self.apply = function ( data, event ) {
        spxapi.ui.loading(event.target);
        var value = self.toJS();
        return spxapi.rpc.variable_set( self.variable, value ).done( function( data ) {
            // should update the local storage  
            updateLocalStorage( value );
        }).always( function() {
            spxapi.ui.reset(event.target);
        });   
    };
    
    if ( args.cancel ) {
        self.cancel = args.cancel;
    } else if ( args.cancelHref) {
        self.cancel = function ( data, event ) { 
            location.href = args.cancelHref; 
        };
    } else {
        self.cancel = function ( data, event ) { 
            window.close();
        };
    }
    
    if ( args.save ){
        self.save = args.save;
    } else {
        self.save = function ( data, event ) {
            self.apply( data, event ).done( function() {
                self.cancel( data, event );
            });
        };
    }   
    
    if( args.load )
        self.load();
    
    return self;
};

