<?php

class m141113_000000_auth extends CDbMigration
{
	
	public function safeUp()
	{
        $this->createTable('Users', array(
            'id'            => 'INTEGER         NOT NULL PRIMARY KEY AUTOINCREMENT',
            'username'      => 'VARCHAR(64) 	NOT NULL UNIQUE',
            'password'      => 'VARCHAR(256)    NOT NULL'
        ));
        
        
        // user structure
        $this->createTable('AuthItem', array(
            "name"          =>      "varchar(64) not null PRIMARY KEY",
            "type"          =>      "integer not null",
            "description"   =>      "text",
            "bizrule"       =>      "text",
            "data"          =>      "text"
        ));
        $this->createTable('AuthItemChild', array(
            "parent"        =>       "varchar(64) not null",
            "child"         =>       "varchar(64) not null",
            "primary key ('parent','child')",
            "foreign key ('parent') references 'AuthItem' ('name') on delete cascade on update cascade",
            "foreign key ('child') references 'AuthItem' ('name') on delete cascade on update cascade"
        ));
        
        
        $this->createTable('AuthAssignment', array(
            "itemname"      =>       "varchar(64) not null",
            "userid"        =>       "varchar(64) not null",
            "bizrule"       =>       "text",
            "data"          =>       "text",
            "primary key ('itemname','userid')",
            "foreign key ('itemname') references 'AuthItem' ('name') on delete cascade on update cascade"
        ));
	}

	public function safeDown()
	{
        $this->dropTable('Users');
        $this->dropTable('AuthItem');
        $this->dropTable('AuthItemChild');
        $this->dropTable('AuthAssignment');
	}
	
}