<?php
class DisplayConfig extends CFormModel {
	
    public $videMode="/etc/default/vidmode";
    public $_deviceName=null;
    public $_screenId=null;
   
    protected $domdoc=null;
    public function rules() {
        $res = array(
            //array( "id", 'safe', 'on'=>'Save' ),
    	);
        return $res;
    }
    
    public function loadConfig() {
        if ( !file_exists( $this->configName ) ) return false;
        $spxconf=file_get_contents($this->configName);
        if (!$spxconf || $spxconf=="") return false;
        $this->domdoc = new DOMDocument;
	    if ( !$this->domdoc->loadXML($spxconf) ) return false;
        return true;
    }
    
    public function getDeviceName() {
        if ( $this->_deviceName===null ){
            if ( $this->domdoc===null && !$this->loadConfig() ) return "error";
          
            $this->_deviceName="";          
            $reporting=$this->domdoc->getElementsByTagName("reporting");
            if ($reporting->length==1){
                $reporting=$reporting->item(0);
                if ($reporting->hasAttribute("deviceName")) $this->_deviceName=$reporting->getAttribute("deviceName");
            }
            if ( $this->_deviceName=="" )
                $this->_deviceName=Yii::app()->device->serial;
        } 
            
        return $this->_deviceName;
    }
    public function setDeviceName( $deviceName ) {
        $this->_deviceName = $deviceName;
    }
    
    public function getScreenId() {
        
        if ( $this->_screenId===null ){
            if ( $this->domdoc===null && !$this->loadConfig() ) return "error";
            
            $this->_screenId="";
            $multiscreen=$this->domdoc->getElementsByTagName("multiscreen");
            if ($multiscreen->length==1){
                $multiscreen=$multiscreen->item(0);
                if ($multiscreen->hasAttribute("screenId"))
                    $this->_screenId=$multiscreen->getAttribute("screenId");
            } 
            if ( $this->_screenId=="" )
                $this->_screenId=Yii::app()->device->serial;
        }
        return $this->_screenId;
    }
    public function setScreenId( $screenId ) {
        $this->_screenId = $screenId;
    }
}