<?php
require_once 'protected/utils/PullMode.php';

class SyncSource extends CModel {
    var $dest = "";    
    var $norecurs = 0;    
    var $uri;
    var $update;
    var $time = "00:00";
    public function attributeNames() {
        return array("dest", "uri", "update", "time" );
    }
    public function rules() {
		$res = array(
            array( "dest", 'checkNames' ),
            array( "uri", 'SimpleURLValidator', "allowEmpty"=> false ),            
            array( "update", 'in', 'range' => array('manual', 'hourly', 'daily'), 'allowEmpty'=>true ),
            array( "time", 'date', 'format' => array('H:mm', "HH:mm"), 'allowEmpty'=>true ),
            array( "norecurs", 'in', 'range' => array( 0, 1), 'allowEmpty'=>true ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
        return array(
            'dest' => 'Destination folder',
            'uri' => 'Server URI',
            'update' => 'Update',
            'time' => 'Time',
            'norecurs' => "Do not update sub-folders"
        );
        
	}   
    public function checkNames( $attribute ){
        $value = $this->$attribute;
        if ( $value == "" ){
            return true;
        }
        if ( preg_match('/[^\w\d-]/', $value) || strlen($value)>63 || $value[0]=="-" || $value[strlen($value)-1]=="-" ) {
			$this->addError($attribute, "$attribute ('".htmlspecialchars($value)."') is not valid. It may contain only ASCII letters, digits and the hyphen");
            return false;
		}
        return true;
    }
    
    function publish( ) {
        $pullMode = new PullMode();
        $options = array();
        if ( !empty($this->dest) ){
            $options[] = "-dest ".$this->dest;
        }
        if ( $this->norecurs ){
            $options[] = "-norecurs";
        }
        $id = $pullMode->createEvent( "publish", $this->uri, 30, $options );
        return $id;
    } 
    function publishStatus( $id ) {
        $pullMode = new PullMode();        
        $status = $pullMode->getStatus( $id );
        if ( $status['state'] == 'notfound' ){
            $this->addError('uri', "Publish ID not found" );
        } else if ( $status['state'] == 'finished' && $status['success'] != 1 ){
            foreach ( $status['errors'] as $error ){
                $this->addError('uri', $error['description'] );
            }            
        }
        return $status;
    }
}