<?php

/**

 */
class Project extends Resource
{
    private $contentFonts = "/srv/raperca/content/fonts/";
    private $renderFile = "index.svg";
    private $projectFolder = "project/";
    protected $configFile = "config.json";
    protected $_uploadedfile = null;
    protected $config = null;
    protected $optionId = 0;
    
    var $query = null;
    /**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		$rules = parent::rules();
        $rules[] = array('query', 'validateQuery');
    	return $rules;
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'id',
			'name' => 'name',
		);
	}
    public function init(){
        parent::init();
        $this->type = "project"; 
    }
    public function defaultScope(){
        return array(
            'condition'=>"type='project'",
        );
    }
    public function validateQuery( $attribute ){        
        if ( $attribute!="query" ){
            $this->addError( $attribute, "should be query" );
            return false;
        }
        if ( $this->$attribute === null ){
            return true;
        }
        $val = new Validator( $this, "query" );
        
        $this->loadConfig();
        $options = array();
        foreach ( $this->config['params'] as $item){
            $options += $item['options'];            
        }
        return $val->validateQuery($this->$attribute, "query", $options );
    }
    public function removeChild( $childId, $delayPreview = false ) {
                
        if ( $this->save() ) {
            return true;
        } else {                   
            return false;
        }
    }
    public function rollback() {        
        parent::rollback( );
    }
    
    public function getHref() {
        return parent::getHref() . $this->projectFolder. $this->renderFile;
    }
    public function getDur() {
        $this->loadConfig();
        if ( isset($this->config['dur']) ){
            return $this->config['dur'];
        } else {
            return 0;
        }
    }
    public function getListDesc( $preview=true ) {
        $description = array(
            'id' => $this->id,
            'name' => $this->name,
            'type' => $this->type,
            'href' => $this->href,            
            'manage' => $this->manage,
            'modified' => $this->modified,
            'keywords' => $this->keywords
        );        
        if (  $preview ) {
            $previews = $this->previews;
            if ( count( $previews ) )
                $description['previews'] = $previews;
        }
        $this->loadConfig();
        if ( isset($this->config['dur']) ){
            $description['dur'] = $this->config['dur'];
        }
        
        return $description;
    }
    public function getDesc( $parents = true, $short = false ) {
        $description = $this->getListDesc( !$short ); 
        
        $description['params'] = $this->config['params'];   
        $description['query'] = $this->getOptionsData($this->config);
        if ( $parents ) {
            foreach ( $this->parents as $parent ){
                $description['parents'][] = $parent->getListDesc( false );
            }
        }
        return $description;
    }
    public function processFile( $name = null ) {
        if ( !$name )
            $this->_uploadedfile = CUploadedFile::getInstance( $this, 'file' );
        else if ( is_array($name) )
            $this->_uploadedfile = new UploadedFileTest( $name );
        else if ( $name=="PUT" )
            $this->_uploadedfile = new UploadedFilePut();
        else
            $this->_uploadedfile = CUploadedFile::getInstanceByName( $name );
        
        return true;
    }
    public function loadConfig( $assign = true ) {
        if ( $this->config !== null) {
            return $this->config;
        }
        $where = $this->getFolder();
        if ( !file_exists( $where . $this->configFile)){
            return array();
        }
        $file = file_get_contents($where . $this->configFile);
        if ( empty( $file ) ){
            return array();
        }
        $config = json_decode( $file, true);
        if ( $assign ){
            $this-> config = $config;
        }
        return $config;
    }
    public function saveConfig( $config = null ) {
        if ( $config === null ){
            $config = $$this->config;
        }
        $where = $this->getFolder();
        return file_put_contents($where . $this->configFile, json_encode($config));
    }
    public function extractArchive( $where ) {
        $projectPath = $where . $this->projectFolder;
        
        if ( $this->_uploadedfile->type == 'dir' ){
            // for unit testing and backup
            rmdir( $this->getFolder() );
            rename($this->_uploadedfile->tempName, $this->getFolder() );                
        } else {
            $zip = new ZipHandler;        
            if ( !$zip->open( $this->_uploadedfile->tempName, "7z", true ) ){
                $this->addError('media', $zip->error );
                return false;
            }
            if ( in_array("index.svg", $zip->content) ) {
                // index is at the root
                if ( !file_exists( $projectPath ) ){
                    mkdir( $projectPath );
                }
                if ( $zip->extractTo( $projectPath )===false ){
                    $this->addError('media', $zip->error );
                    return false;
                }
            } else {
                // project is in specifc folder 
                if ( file_exists( $projectPath ) ){
                    GlobalSettings::rrmdir( $projectPath, true );
                }
                $folder = $zip->folders[1]. DIRECTORY_SEPARATOR;
                if ( $zip->extractTo( $where )===false ){
                    $this->addError('media', $zip->error );
                    return false;
                }
                rename($where.$folder, $projectPath);
            }
        }
        /*
        if ( file_exists($projectPath.'fonts/') ) {            
            tools::save_symlink($projectPath.'fonts', $this->contentFonts . $this->id);
        }         
         */
        
        
        
        return true;
    }
    protected function getFonts() {
        $fontsFolder = "/etc/spxmanage/fonts/conf.d/";
        $fontsFiles = array( "msttcorefonts.info", "noto-fonts.info", "noto-cjk.info");
        
        $fonts = array();
        foreach ( $fontsFiles as $fontsFile ){
            $file = file_get_contents($fontsFolder . $fontsFile);
            $json = json_decode($file, true);
            foreach ( $json[  "user-families" ] as $value ){
                $family = "\"" . $value["family"] . "\"";
                foreach ( $value["fallbacks"] as $f ){
                    $family .= ",\"$f\"";
                }
                $fonts[] = array( 'name' => $value["family"], 'value' => $value["family"], 'preview' => $family );
            }            
        }
        return $fonts;
    }
    protected function getJSONProperty( $json, $property ) {
        $props = explode( ".",  $property );
        foreach ( $props as $p ) {
            if ( !isset($json[$p]) ){
                Yii::log("Cannot find $p in ".  json_encode($json), 'debug', 'spx.project');
                return null;
            }
            $json = $json[$p];
        }
        return $json;
    }
    protected function setJSONProperty( &$json, $property, $value ) {        
        $props = explode( ".",  $property );
        $j = $json;
        foreach ( $props as $p ) {
            if ( !isset($j[$p]) ){
                Yii::log("Cannot find $p in ".  json_encode($j), 'debug', 'spx.project');
                return null;
            }
            $j = $j[$p];
        }
        if ( count($props)==1 ) {
            $json[ $props[0] ] = $value;
        } elseif ( count($props)==2 ) {
            $json[ $props[0] ][ $props[1] ] = $value;
        }elseif ( count($props)==3 ) {
            $json[ $props[0] ][ $props[1] ][ $props[2] ] = $value;
        }elseif ( count($props)==4 ) {
            $json[ $props[0] ][ $props[1] ][ $props[2] ][ $props[3] ] = $value;
        }elseif ( count($props)==5 ) {
            $json[ $props[0] ][ $props[1] ][ $props[2] ][ $props[3] ][ $props[4] ] = $value;
        }elseif ( count($props)==6 ) {
            $json[ $props[0] ][ $props[1] ][ $props[2] ][ $props[3] ][ $props[4] ][ $props[5] ] = $value;
        }elseif ( count($props)==7 ) {
            $json[ $props[0] ][ $props[1] ][ $props[2] ][ $props[3] ][ $props[4] ][ $props[5] ][ $props[6] ] = $value;
        }elseif ( count($props)==8 ) {
            $json[ $props[0] ][ $props[1] ][ $props[2] ][ $props[3] ][ $props[4] ][ $props[5] ][ $props[6] ][ $props[7] ] = $value;
        }                 
    }
    public function getSetOptionsData( $config, $data = null ) {
        $projectPath = $this->getFolder() . $this->projectFolder;
        $get = $data === null;
        if ( $get ){
            $data = array();
        }
        foreach ( $config['params'] as $item){
            $name = $item['name'];
            $options = $item['options'];
            $cnt = file_get_contents($projectPath . $name); 
            if ( $get ){
                Yii::log("Loading data for: ".$name, 'info', 'spx.project');
            } else {
                Yii::log("Saving data for: ".$name, 'info', 'spx.project');
            }
            $dom = new DOMDocument;
            if ( @$dom->loadXML( $cnt )===false ){
                Yii::log("Cannot load XML for: ".$name, 'warning', 'spx.project');
                continue;
            }
            // must fix the ids of the doc
            foreach ($dom->getElementsByTagName('*') as $element) {
                if ($element->hasAttribute('id')) {
                    $element->setIdAttribute('id', true);
                }
            }
            foreach ( $options as $id => $option ){
                if ( !$get && !isset($data[$id]) ){
                    continue;
                }
                $item = $dom->getElementById( $option['id'] );
                if ( $item===null ) {
                    Yii::log("Cannot find id $id", 'warning', 'spx.apps');
                    continue;
                }
                if ( isset($option['propertyName']) ){
                    $json = json_decode( $item->textContent, true );
                    if ( $json === null ){
                        Yii::log("Cannot decode content of id $id", 'warning', 'spx.apps');
                        continue;
                    }
                    if ( $get ){
                        $value = $this->getJSONProperty( $json, $option['propertyName'] );
                        $data[$id] = $value;
                    } else {
                        $this->setJSONProperty( $json, $option['propertyName'], $data[$id] );                    
                        $newText = new DOMText(json_encode( $json ));
                        $item->removeChild($item->firstChild);
                        $item->appendChild($newText);                    
                        Yii::log("Updated $id to: ".$item->textContent, 'debug', 'spx.apps');
                    }           
                } else if ( isset($option['targetAttribute']) ){
                    if ( $get ){
                        $data[$id] = $item->getAttribute( $option['targetAttribute'] );
                    } else {
                        $item->setAttribute( $option['targetAttribute'], $data[$id] );                    
                    }  
                } else {
                    if ( $get ){
                        $data[$id] = $item->textContent;
                    } else {
                        $newText = new DOMText($data[$id]);
                        $item->removeChild($item->firstChild);
                        $item->appendChild($newText);                                            
                    }  
                }
            }
            if ( !$get ){
                file_put_contents( $projectPath . $name, $dom->saveXML() );   
            }
        }
        return $data;
    }
    
    public function getOptionsData( $config ) {
        return $this->getSetOptionsData( $config );        
    }
    public function setOptionsData( $config, $data ) {
        return $this->getSetOptionsData( $config, $data );
    }
    protected function getLayerOptions( $json, $enabled = false ) {
        $option = array();
        if ( !isset( $json["args"] ) || !isset( $json["ctor"] )){
            Yii::log("args or ctor not found for layer (".  json_encode($json).")", 'debug', 'spx.project');
            return null;
        }
        if ( isset( $json["name"]) ){
            $option['name'] = $json["name"];
            Yii::log("Found option for ". $option['name'], 'debug', 'spx.project');
        } else if ( !$enabled ){            
            Yii::log("name not found for layer", 'debug', 'spx.project');
            return null;
        }
        $ctor = $json["ctor"];
        if ( in_array($ctor, array('textArea', 'fitTextArea', 'scrollingTextArea') ) ){
            $option['type'] = 'text';      
            $textContent = true;
        } else if ( in_array($ctor, array('pingPongTextArea', 'headlineTextArea') ) ){
            $option['type'] = 'string';
            $textContent = true;
        } else if ( in_array($ctor, array('media', 'animation', 'image', 'video') ) ){
            $textContent = false;
            Yii::log("media not supported", 'debug', 'spx.project');
            return null; // not supported for the moment
        } else {            
            Yii::log("unknown ctor: ".$ctor, 'debug', 'spx.project');
            return null;
        }
        
        $option['desc'] = isset($json["desc"])?$json["desc"]:"";
        if ( $textContent ){
            if ( isset( $json["textContent"]) && isset( $json["textContent"]["text"] ) ){
                $option['propertyName'] = "textContent.text";
            } else {
                $option['propertyName'] = "textContent";
            }
            /*
            if ( !isset( $json["textContent"] ) ){
                $option['value'] = "";
                
            } else if ( !is_array( $json["textContent"] ) ) {
                $option['value'] = $json["textContent"];                
            } else if ( isset( $json["textContent"]["text"] ) ){
                $option['value'] = $json["textContent"]["text"];                
            } else {
                // get all the text, but formating will be lost
                $option['value'] = "";
                foreach( $json["textContent"] as $txt ) {
                    $option['value'] .= $txt["text"];
                }                
            }             
            */
        }
        return $option;
    }
    public function getConfigurableFields( $dom ) {
        // must fix the ids of the doc
        foreach ($dom->getElementsByTagName('*') as $element) {
            if ($element->hasAttribute('id')) {
                $element->setIdAttribute('id', true);
            }
        }
        
        $options = array();
        $params = $dom->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "properties");        
        $entrys = array();
        foreach( $params as $param ) {            
			for ( $item=$param->firstChild; $item!=null; $item=$item->nextSibling ) {
				if ( $item->nodeType==XML_ELEMENT_NODE ) {
                    if ( $item->localName=='group' ) {
                        $base = $item->getAttribute("name");
                        for ( $item2=$item->firstChild; $item2!=null; $item2=$item2->nextSibling ) {
                            if ( $item2->nodeType==XML_ELEMENT_NODE ) {
                                $name = $item2->getAttribute("name");
                                if ( $name === 'Visible' ){                                    
                                    $item2->setAttribute("name", $base);
                                } 
                                Yii::log("Adding ". $base .":". $name, 'debug', 'spx.project');
                                $entrys[ $base .":". $name] = $item2;
                            }
                        }
                    } else {
                        $name = $item->getAttribute("name");
                        Yii::log("Adding ". $name, 'debug', 'spx.project');
                        $entrys[ $name ] = $item;
                    }
				}
			}
        }
        foreach ($entrys as $name => $entry) {
            if ( substr($entry->localName, 0, 4) == "json" ){
                $type = substr($entry->localName, 5);
            } else if ( $entry->localName == "color" ){
                // exceptionally we also supprt non-json props for color as they are used in many widgets even in the latest Elementi
                $type = "color";
            } else {
                Yii::log("Non JSON props for ". $entry->localName. " ($name)", 'debug', 'spx.project');
                continue; // only json properties are supported
            }
            
            if ( $type === 'array') {
                Yii::log("Checking array for $name", 'debug', 'spx.project');
                $id = substr( $entry->getAttribute("xlink:href"), 1 );
                $table = $dom->getElementById( $id );
                if ( $table===null ) {
                    Yii::log("Cannot find id $id", 'debug', 'spx.project');
                    continue;
                }
                $json = json_decode( $table->textContent, true );
                if ( $json === null ){
                    Yii::log("Cannot decode JSON for id $id", 'debug', 'spx.project');
                    continue;
                }
                foreach( $json as $idx=>$media ) {
                    Yii::log("Checking layer ". $idx, 'debug', 'spx.project');
                    // only simple layer with single elemet are supported
                    $option = $this->getLayerOptions($media);
                    if ( $option !== null ){
                        $option['id'] = $id;
                        $option['propertyName'] = "$idx.".$option['propertyName'];
                        $options[ "opt".$this->optionId++ ] = $option;
                        Yii::log("Got options for  layer ". $idx, 'debug', 'spx.project');
                    } else {
                        Yii::log("No option for layer". $idx, 'debug', 'spx.project');
                    }
                }
                continue;
            }
            Yii::log("Type: $type for $name", 'debug', 'spx.project');
            if ( $entry->getAttribute("ui") !== "enabled") {
                Yii::log("UI not enabled for ". $entry->getAttribute("name"), 'debug', 'spx.project');
                continue;
            }
            $option = array();
            $option['name'] = $entry->getAttribute("name");
            $option['desc'] = $entry->getAttribute("desc");
            $option['id'] = substr( $entry->getAttribute("xlink:href"), 1 );
            
            $id = $option['id'];
            $layer = $dom->getElementById( $id );
            if ( $layer===null ) {
                Yii::log("Cannot find id $id", 'debug', 'spx.project');
                continue;
            }
            if ( $entry->hasAttribute("propertyName") ) {
                $json = json_decode( $layer->textContent, true );
                if ( $json === null ){
                    Yii::log("Cannot decode JSON for id $id", 'debug', 'spx.project');                    
                    continue;
                }   
                $propertyName = $entry->getAttribute("propertyName");
                Yii::log("Checking #$id -> $propertyName", 'debug', 'spx.project');
                $propertyValue = $this->getJSONProperty($json, $propertyName);
                
                $option['propertyName'] = $propertyName;                
            } else if ( $type === "color" ){
                if ( $entry->hasAttribute("targetAttribute") ) {
                    $option['targetAttribute'] = $entry->getAttribute("targetAttribute");  
                }
            } else {
                Yii::log("Missing propertyName for id $id", 'debug', 'spx.project');                    
                continue;
            }
            if ( $type === 'layer') {
                $option2 = $this->getLayerOptions($propertyValue, true);
                if ( $option2 !== null ){
                    $option += $option2;
                    $option['propertyName'] = $propertyName.".".$option['propertyName'];
                    $options[ "opt".$this->optionId++ ] = $option;
                    Yii::log("Got options for  layer ". $name, 'debug', 'spx.project');
                } else {
                    Yii::log("No option for layer". $name, 'debug', 'spx.project');
                }
                continue;                
            }
                        
            if ( $type==='data' ){
                $option['type'] = 'string';
            } else if ( $type==='integer' ){
                $option['type'] = 'number';
            } else {
                $option['type'] = $type;
            }
            
            if ( !in_array($option['type'], array('string', 'text', 'number', 'boolean', 'choice', 'color') ) ){
                Yii::log("Type not supported: ". $option['type'], 'debug', 'spx.project');
                continue;
            }
            
            
            if ( $type==='data' ){                
                $data = $propertyValue;
                if ( $data['type'] == 'uri' ){
                    $option['propertyName'] .= ".src";
                } else if ( $data['type'] == 'spreadsheet' && $data['parser']['provider'] == 'csv' ){
                    $option['propertyName'] .= ".parser.workbook";
                } else if ( $data['type'] == 'calendar' && $data['parser']['provider'] == 'ics' ){
                    $option['propertyName'] .= ".parser.calendar";
                } else if ( $data['type'] == 'finance' ){
                    $option['propertyName'] .= ".parser.symbol";
                } else if ( $data['type'] == 'post' && $data['parser']['provider'] == 'twitter'){
                    if ( $data['parser']['timeline'] === 'user' ){
                        $option['propertyName'] .= ".parser.username";
                    } else if ( $data['parser']['timeline'] === 'search' ){
                        $option['propertyName'] .= ".parser.query";
                    } else {
                        Yii::log("Twitter option not supported for ".$option['name'], 'debug', 'spx.project');                    
                        continue;
                    }
                } else if ( $data['type'] == 'post' && $data['parser']['provider'] == 'facebook'){
                    $option['propertyName'] .= ".parser.name";
                } else {
                    Yii::log("Parser not supported for ".$option['name'], 'debug', 'spx.project');                    
                    continue;
                }                 
            }
            if ( $entry->hasAttribute("default") ){
                $option['default'] = $entry->getAttribute("default");
            }
            if ( $type==='text' ){                
                if ( isset( $propertyValue["text"] ) ){
                    $option['propertyName'] .= ".text";
                }
            }  
            if ( $type==='number' ){
                if ( $entry->hasAttribute("min") )
                    $option['min'] = (float)$entry->getAttribute("min");
                if ( $entry->hasAttribute("max") )
                    $option['max'] = (float)$entry->getAttribute("max");
                if ( $entry->hasAttribute("step") )
                    $option['step'] = (float)$entry->getAttribute("step");
                if ( isset($option['default']) ){
                    $option['default'] = (float)$option['default'];
                }
            }
            if ( $type==='number' && isset($option['min']) && isset($option['max']) ){
                $option['type'] = $type = 'slider';
            }
            if ( $type==='boolean' ){
                if ( $entry->hasAttribute("true") )
                    $option['true'] = $entry->getAttribute("true");
                if ( $entry->hasAttribute("false") )
                    $option['false'] = $entry->getAttribute("false");
                if ( isset($option['default']) ){
                    $option['default'] = $option['default'] === "true";
                }
            }            
            if ( $type==='choice' ){
                $select = array();
                if ( $entry->hasAttribute("choice") ){
                    if ( $entry->getAttribute( "choice" ) == 'fonts' ){
                        $option['select'] = $this->getFonts();
                    } else {
                        $option['type'] = $entry->getAttribute( "choice" );
                    }                    
                } else {
                    $i = 1 ;
                    if ( $entry->hasAttribute("choice-1") )
                        $add = false;
                    else 
                        $add = true;
                    $idx = ($i<10&&$add)?"0".$i:$i;

                    while ( $entry->hasAttribute("choice-".$idx) ){
                        $val = array( "value" => $entry->getAttribute( "choice-".$idx ) );
                        if ( $entry->hasAttribute("name-".$idx) ){
                            $val['name'] = $entry->getAttribute( "name-".$idx );
                        } else {
                            $val['name'] = $entry->getAttribute( "choice-".$idx );
                        }
                        $select[] = $val;
                        $i++;
                        $idx = ($i<10&&$add)?"0".$i:$i;
                    }
                
                    if ( count($select) == 2 
                            && ( $select[0]['value']=='yes' || $select[0]['value']=='no' )
                            && ( $select[1]['value']=='yes' || $select[1]['value']=='no' )){
                        $option['type'] = 'boolean'; 
                        $option['true'] = $select[0]['value']=='yes' ? $select[0]['name']:$select[1]['name'];
                        $option['false'] = $select[0]['value']=='no' ? $select[0]['name']:$select[1]['name'];
                    } else if ( count($select)>0 ){
                        $option['select'] = $select;                    
                    } else {
                        $option['type'] = 'string';
                    } 
                }
            }
            
            $options[ "opt".$this->optionId++ ] = $option;
        }
        return $options;
    }
    public function createConfig( $where ) {
        $projectPath = $where . $this->projectFolder;
        
        // get the config
        $config = array();
        $index = file_get_contents($projectPath . $this->renderFile);
        $name = $this->_uploadedfile->name;
        Yii::log("Extracting data for: ".$name, 'info', 'spx.project');
        $dom = new DOMDocument;
        if ( @$dom->loadXML( $index )===false ){
            Yii::log("Cannot load XML for: ".$name, 'warning', 'spx.apps');
            return false;
        }        
        $svg = $dom->documentElement;
        if ( !$svg ) {
            Yii::log("Cannot find SVG for: ".$name, 'warning', 'spx.apps');
            return false;
        }
        if ( $svg->hasAttribute("viewBox") ){
            $dim = explode(" ", $svg->getAttribute("viewBox") );
            if ( count($dim)==4 ) {
                $config['width'] = $dim[2];
                $config['height'] = $dim[3];
            }            
        }
        if ( $svg->hasAttribute("dur") ){
            $dur = $svg->getAttribute("dur");
            if ( $dur != 'indefinite'){
                $config['dur'] = floatval($dur);
            } 
        }
        $this->optionId = 0;
        $options = $this->getConfigurableFields($dom);
        $config['params'] = array();
        if ( !empty($options) ){
            $config['params'][] = array( 'name'=>$this->renderFile, 'options' => $options );
        }
        
        // get the list of all SVG file in this folder
        $files = CFileHelper::findFiles( $projectPath,  array( 'fileTypes'=>array('svg'), 'level'=>0 ) );
        foreach ( $files as $file ) {
            if ( basename($file) == basename($this->renderFile) ) {
                continue;
            }
            $cnt = file_get_contents($file);
            $name = basename($file);
            Yii::log("Extracting data for: ".$name, 'info', 'spx.project');
            $dom = new DOMDocument;
            if ( @$dom->loadXML( $cnt )===false ){
                Yii::log("Cannot load XML for: ".$name, 'warning', 'spx.apps');
                continue;
            }
            $options = $this->getConfigurableFields($dom);            
            if ( !empty($options) ){
                $config['params'][] = array( 'name'=>$name, 'options' => $options );
            }        
        }        
        $this->saveConfig( $config );
        $this->config = $config;
    }
    public function getPreviews() {
        $where = $this->getFolder() ;
        if ( !file_exists( $where . "previews/" ) ){
            // previews do not existe, we generate them now
            $this->generatePreviews( $where );
        }
        return parent::getPreviews();
    }
    public function generatePreviews( $where ) {
        $path = $where."previews/";
        if ( $this->delayPreview ){
            if (file_exists($path) ){
                GlobalSettings::rrmdir( $path, true );
            }
            return;
        }
        $rootDir = GlobalSettings::$fileBase;
        
        // clear up the preview folder and create it
        
        if (file_exists($path) )
            GlobalSettings::rrmdir( $path, false );            
        else
            mkdir( $path );
        
        $this->loadConfig();
        
        $exe="cd /srv/raperca && raperca";
        if( PHP_OS == "WINNT" ){
            $exe = "C:\\SpinetiX\\sources\\genesis\\trunk\\user\\hmd\\bin_d\\raperca.exe";
            if ( !file_exists( $exe ) ){
                $exe = "\"C:\\Program Files (x86)\\SpinetiX\\Elementi\\Elementi\\bin\\raperca.exe\"";
            }
        } else if (file_exists('/opt/sysroot/usr/local/lib/liblive555.so.0')) {
            // this is a Bonsai/Sakura system hacked as Ikebana, need special LD_LIBRARY_PATH
            $exe = "cd /srv/raperca && LD_LIBRARY_PATH=/opt/sysroot/lib:/opt/sysroot/usr/lib:/opt/sysroot/usr/local/lib raperca";
        }
        
        $file = $this->renderFile;
              
        $size = array( $this->config['width']/2, $this->config['height']/2 );
        $width = $size[0];
        $height = $size[1];
        $dimension = "{$width}x{$height}";
        
        $cmd = "$exe -preview -s " . escapeshellarg($dimension) . " -pm 1 -d " . escapeshellarg($rootDir) . " " . escapeshellarg($this->gethref()) . " 2>&1";
        $previewFile = $where . $this->projectFolder . ".preview." . $this->renderFile .".png";
        
        Yii::log($cmd, 'info', 'spx.preview');
        $output = array();
        $ret = -1;
        exec( $cmd, $output, $ret );
        if ( $ret !== 0 && PHP_OS == "WINNT" ) {
            $img = imagecreatetruecolor($width/2, $height/2);
            $textcolor = imagecolorallocate($img, 255, 255, 255);
            imagestring( $img, 5, 10, $height/4, $this->name, $textcolor);            
            imagepng( $img, $previewFile);
            $ret = 0;
        }        
        if ( $ret==0 ) {
            // move to the preview folder
            @rename($previewFile, $path."preview_$dimension.png");
            // create smaller images
            while ( $size[0]>100 && $size[1]>50 ){
                $size[0] = round( $size[0]/2 );
                $size[1] = round( $size[1]/2 );
                $this->previewsImage( $size[0]."x".$size[1], $path, $path, "preview_$dimension.png" );            
            }                     
        } 
        
        // default previews
        @copy( GlobalSettings::$systemMedia."project.png", $path."preview_98x58_0_default.png" );
        
    }

    public function recover( $file = null ){
        $path = $this->getFolder();        
        $recover = parent::recover($path . $this->projectFolder . $this->renderFile);     
        if ( $recover ){
            $this->createConfig( $path );
        }
        return $recover;
    }
    public function saveFiles(){
        $path = $this->getFolder();
        if ( $this->_uploadedfile !== null ){
            $this->extractArchive( $path );
            $this->createConfig( $path );
        }
        if ( $this->query ){
            $this->setOptionsData($this->loadConfig(), $this->query);
            // setup have changed, need to update the preview
            $this->generatePreviews( $path );
        }
        return true;
    }
    public function beforeSave(){
        if ( !$this->isNewRecord && !$this->saveFiles() ){
            return false;
        }
        return parent::beforeSave();
    }
    public function afterSave(){ 
        parent::afterSave();
            
        if ( $this->isNewRecord && !$this->saveFiles() ){
            throw new Exception( "save failed" );
        }        
    }
    public function beforeDelete() {     
        /*
        $projectPath = $where . $this->projectFolder;        
        if ( file_exists($projectPath.'fonts/') ) {            
            if ( PHP_OS == "WINNT" ) {
                unlink( $this->contentFonts . $this->id .".link" );                
            } else {
                unlink( $this->contentFonts . $this->id );
            }            
        }         
        */
        
        return parent::beforeDelete();
    }
    
    /**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Playout the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}

