<?php

class PlayingController extends Controller
{
    public $defaultAction = 'schedule';
    
    public function accessRules()
    {
        $rules = array(      
            array('allow',  
                'actions' => array( "create" ),
                'roles'=>array( 'viewMedia', 'viewPlaylist', 'viewPlayout', 'viewApps' ),
            ),
            array('allow',  
                'actions' => array( "schedule" ),
                'roles'=>array('viewSchedule'),
            ),
            array( 'deny' )
        );        
        return $rules;
    }
    
	public function actionCreate()
	{       
        $options = array();
        if ( isset($_GET['filter']) ){
            $options['filter'] = $_GET['filter'];
        }
		$this->render('create', $options);
	}
    public function actionSchedule()
	{     
        $playerConfig = new PlayerConfig;
        
		$options = array(   
            'vertical' => substr($playerConfig->orientation,0, 6 ) == "rotate"
        );        
		$this->render('schedule', $options);
	}
}