<?php


class ZipHandler {
    //static $exe = '"C:\Program Files\7-Zip\7za"';
    static $exe = "ulimit -v 12288 && 7za";
    static $win32exe = '"C:\Program Files\7-Zip\7z"';
    var $name;
    var $content=array();
    var $folders=array();
    var $type='7zip';
    
    var $error=null;
    
    
    function open( $name, $type = '7z', $list=true ) {
        if(PHP_OS == "WINNT"){
            self::$exe = self::$win32exe;
        }
        if ( file_exists($name) ){
            if ( $list ) {
                $ret = $this->getFileList( $name, $type, $this->content, $this->folders );
                if ( $ret!==true ) {
                    $this->error = $ret;
                    return false;
                }
            }
            $this->name = $name;
            $this->type = $type;
            
            return true;
        }
        $this->error = I18N::t('File not found') ." : ".$name;
        return false;
    }
    
    function close( ) {
    }
    
    function fileList( ) {
        return self::getFileList( $this->name );
    }
    
    static function getFileList( $name, $type, &$content, &$folders ) {
        $out = array();
        $code = 0;
        if(PHP_OS == "WINNT")
            self::$exe = $win32exe;
        
        $cmd = self::$exe . " l " . escapeshellarg($name) . " 2>&1";
        
        $last = exec( $cmd, $output, $code );
        if ( $code!=0 ) {
            return self::parseError( $code, $output );
        }
        if ( $type=='zip' ) {
            // check that there are not a single UTF-8 char in the zip file
            foreach ($output as $line ) {
                $enc = mb_detect_encoding($line);
                if ( $enc!="ASCII" ) {
                    return I18N::t('Zip file contains invalid encoding').": ".$enc.". ".I18N::t('Only ASCII characters are supported. Use 7-Zip format for non-ASCII characters.');
                }
            }
        }
		
        foreach ($output as $line ) {
            $ok = preg_match("/\S+\s+\S+\s+(\S+)\s+\S+\s+\S+\s+(.*)/u", $line, $matches);
			if ( !$ok )
				$ok = preg_match("/\S+\s+\S+\s+(\S+)\s+\S+\s+(.*)/u", $line, $matches);
            if ( $ok ){
			    if ($matches[1]=="....." || $matches[1]=="....A"){
                    // file
                    if ( !preg_match("/\.preview/u", $matches[2] ) )
                        $content[]=$matches[2];
                }elseif ($matches[1]=="D...."){
                    // folder
                    $folders[]=$matches[2];
                }
            }
        }
        if ( $type=='zip' && count($folders)>0 && strpos($folders[0], "/")!==false ) {
            // add the base folder in case of zip files, because it is not reported by 7z
            $folders[] = substr($folders[0], 0 , strpos($folders[0], "/") );
        }
        $folders[]= "" ; // always add the root folder
        sort( $folders );
        
        if ( count($content)==0 && count($folders)==0 ) {
            Yii::log("No file found: ".print_r($output, true), 'warning', 'spx.zip');
            return I18N::t( 'Archive contains no files. Make sure you use 7-Zip archive format.');
        } else
            return true;
    }
    static function parseError( $code, $output, $ignoreEmpty=false ) {
        if ( $code==0 )
            return null; // nothing wrong
        elseif ( $code==1 ) {
			foreach ( $output as $line ){
				if ( strpos($line, "No files to process")!==false ){
					if ( $ignoreEmpty )
						return null;
					else
						return I18N::t('File extraction failed.'). " " . I18N::t('No files found in archive.');
				}
                if ( strpos( $line, "not recognized as an internal or external command") !== false ) {
                    returnI18N::t('File extraction failed.'). " " . I18N::t('7z not found.');
                }
			}
			return I18N::t('File extraction failed.'). " " . I18N::t('Your content may be corrupted.');
        } elseif ( $code==2 || $code==8 ) {
            foreach ( $output as $line ){
                if ( strpos($line, "Enter password")!==false ){
                    return I18N::t('File extraction failed.'). " " . I18N::t('Is the archive password protected?');
                }
            }
            return I18N::t('File extraction failed.'). " " . I18N::t('The compression factor may be too high. Try re-generating the archive with the compression level set to Store or Fast.');
        } elseif ( $code==7 ) {
            return I18N::t('File extraction failed.'). " " . I18N::t('Filename may contain invalid characters.');
        } elseif ( $code==255 ) {
            return I18N::t('File extraction failed.'). " " . I18N::t('Process interrupted.');
        }
        return I18N::t('File extraction failed.') ." ($code)";
        
    }
    function extractTo( $dest, $exclude="", $ignoreEmpty=false ) {
        return $this->extractFolderTo( $dest, "", $exclude="", $ignoreEmpty );        
    }
    
    function extractFolderTo( $dest, $basepath="*/", $exclude="", $ignoreEmpty=false ) {
        if(PHP_OS == "WINNT"){
            self::$exe = self::$win32exe;
        }
        
        $cmd = self::$exe . " x " . escapeshellarg($this->name) . " " . escapeshellarg("-xr!.SPXDAV");
        if ( $exclude!="" ) {
        	$cmd .= " " . escapeshellarg("-x!$exclude");
        }
        $cmd .= " -aoa " . escapeshellarg("-o$dest") . " " . escapeshellarg("${basepath}*") . " 2>&1";
        if(PHP_OS != "WINNT") {
            
            if ( $basepath=="*/" )
                $cmd .= " && chmod -R -- a+rX " . escapeshellarg($dest);
            else
                $cmd .= " && chmod -R -- a+rX " . escapeshellarg($dest . $basepath);
        }
        
        
        $last = exec( $cmd, $output, $code );
        
        Yii::trace( $cmd ."\n". print_r($output, true) );
        if ( $code!=0) {
            $this->error = $this->parseError( $code, $output, $ignoreEmpty );
			if ( $this->error!==null )
				return false; // cannot list the content
        }
        
        $out = array();
        foreach ($output as $line ) {
            if (preg_match("/Extracting\s+(.*)/u", $line, $matches) ){
                $out[] = $matches[1];
            }
        }
        
        return $out;
    }
    function extractFileTo( $dest, $files ) {
        if(PHP_OS == "WINNT"){
            self::$exe = self::$win32exe;
        }
        $cmd = self::$exe . " x " . escapeshellarg($this->name) . " -aoa " . escapeshellarg("-o$dest");
        
        foreach ($files as $file ) {
            $cmd .= " " . escapeshellarg($file);
        }
        $cmd .= " 2>&1";
        
        $last = exec( $cmd, $output, $code );
        Yii::trace( $cmd ."\n". print_r($output, true) );
        if ( $code!=0) {
            $this->error = $this->parseError( $code, $output );
            return false; // cannot list the content
        }
        
        $out = array();
        foreach ($output as $line ) {
            if (preg_match("/Extracting\s+(.*)/u", $line, $matches) ){
                $out[] = $matches[1];
            }
        }
        
        return $out;
    }
    function extractExtTo( $dest, $ext ) {
        if(PHP_OS == "WINNT"){
            self::$exe = self::$win32exe;
        }
        if ( is_array($ext) ) {
            $cmd = self::$exe . " e " . escapeshellarg($this->name) . escapeshellcmd(" -xr!.SPXDAV -aoa ") . escapeshellarg("-o$dest") . " -r ";
            $found=false;
            foreach ($ext as $e){
                if ($e=='zip' || $e=='7z' || $e=='xml' )
                    continue;
                if ( $e=='png' )
                	$cmd .= escapeshellcmd("*.png *.PNG -x!.preview.* -x!*.preview.* ");
                else
                	$cmd .= escapeshellarg("*.$e") . " " . escapeshellarg("*." . strtoupper($e)) . " " . escapeshellarg("*.preview.*.${e}.png ");
                $found=true;
            }
            $cmd.="2>&1";
            if ( !$found )
                return array();
        } else {
            if ($ext=='zip' || $ext=='7z' || $ext=='xml' )
                return array(); // we don't do zip files
            if ( $ext=='png' )
            	$cmd = self::$exe . " e " . escapeshellarg($name) . " " . escapeshellarg("-o$dest") . escapeshellcmd(" -r *.png -x!.preview.*") . " 2>&1";
            else
            	$cmd = self::$exe . " e " . escapeshellarg($name) . " " . escapeshellarg("-o$dest") . " -r " . escapeshellarg("*.$ext") . " " . escapeshellarg("*.preview.*.${ext}.png") . " 2>&1";
        }        
        
        $last = exec( $cmd, $output, $code );
        Yii::trace( $cmd ."\n". print_r($output, true) );
        if ( $code!=0) {
            $this->error = $this->parseError( $code, $output );
            return false; // cannot list the content
        }
        $out = array();
        foreach ($output as $line ) {
            if (preg_match("/Extracting\s+(.*)/u", $line, $matches) ){
                if ( !preg_match("/\.preview/u", $matches[1] ) )
                    $out[] = FileItem::basenamepath( $matches[1], $path );
            }
        }
        
        return $out;
    }
    
    function createArchive( $infile, $paths, $base) {
        if(PHP_OS == "WINNT"){
            self::$exe = self::$win32exe;
        }
        
        $cp = 2;
        $name = $infile;
        while ( file_exists( $name ) ) {
            $name = substr($infile, 0, -3) ."(".($cp++).")" .substr($infile, -3);
        }
        //$file = "'" . str_replace("'", "'\\''", $name) . "'" ;
        $file = $name;
        
        $cmd = "cd " . escapeshellarg($base) . " 2>&1 && " . self::$exe . " a " . escapeshellarg($file) . " -t7z -mx0 -mhc=off";
        foreach ($paths as $path ) {
            $cmd .= " " . escapeshellarg($path);
        }
        $cmd.=" 2>&1";
        
        //file_put_contents("/var/log/fusion/debug.log", $cmd ."\n" );
        $last = exec( $cmd, $output, $code );
        Yii::trace( $cmd ."\n". print_r($output, true) );
        
        if ( $code!=0) {
            $this->error = I18N::t('Archive creation failed')." ($code)";
            return false; // cannot list the content
        }
        
        return $name;
    }
 }
