<?php

class HardwareSetup extends CFormModel {

    protected static $configFile = "/etc/network/iface-eth0.conf";
    public $max_temp = false;
	static $temps = array(""=>"Normal", "70"=>"Maximum" );
    
    public $disablePort2 = null;    

    public function rules() {
		return array(
			array('max_temp', 'in', 'range'=>array("", "70", "hot", "cold") ),
            array('disablePort2', 'safe' ),
		);
	}
	public function attributeLabels()
	{
		return array(
			'max_temp'=>'Shutdown temperature',
            'disablePort2'=>'Disable secondary network port',
		);
	}
	
	function loadTemp() {
		$last = exec( "fw_printenv -n maxtemp", $output, $code );
		
		if ( $code==0 )
			return trim($last);
		else 
			return ""; // default
	}
    function saveTemp() {
        
		$cmd = "fw_setenv maxtemp";
		if ( $this->max_temp=="70" || $this->max_temp=="hot" ){
			$this->max_temp = "70";
			$cmd .= " 70";
		}else 
			$this->max_temp="";
        $old = $this->loadTemp();
        if ( $old!=$this->max_temp ) {
            $last = exec( $cmd, $output, $code );
            if ( $code==0 )
                Tools::addReason("Temperature settings changed");
            else {
                $this->addError('max_temp',"Cannot write new temperature settings.");
                return false;
            }
        }
        return true;
	}
    function loadPorts() {
        $ports = false;
        if (file_exists( self::$configFile )){
            $config = file_get_contents(self::$configFile );
            $matches = array();
            if ( preg_match( "|IFACE_DISABLE_SLAVE_1\s*=\s*([01])|", $config, $matches ) >0 ){
                $ports = ($matches[1] == "1" );
            }
        }
		return $ports;
	}
    function savePorts() {
        
        if ( $this->loadPorts() == $this->disablePort2 ){
            return true; 
        }        
        if (file_exists( self::$configFile )){
            $config = file_get_contents(self::$configFile );
        } else {
            $config = "IFACE_DISABLE_SLAVE_0=0\nIFACE_DISABLE_SLAVE_1=0\n";
        }

        $config = preg_replace("|IFACE_DISABLE_SLAVE_1\s*=\s*([01])|", "IFACE_DISABLE_SLAVE_1=".($this->disablePort2?"1":"0"), $config);
        
        if ( !file_put_contents(self::$configFile , $config) ){
            $this->addError('ports',"Cannot write new ports settings.");
            return false;
        }
        Tools::addReason("Network ports settings changed");
        
        if ( ! Tools::setSafeModeData("iface-eth0.conf", $config, FALSE) ){
            $this->addError('ports','Failed saving network configuration for recovery console, please try again.');
            return false;
        }
		return true;
	}
    
	function load() {
        $this->max_temp = $this->loadTemp();
        $this->disablePort2 = $this->loadPorts();
    }
    protected function beforeValidate()
    {
        if ( $this->disablePort2 === null ){
            $this->disablePort2 = $this->loadPorts();
        }
        if ( $this->max_temp === false ){
            $this->max_temp = $this->loadTemp();
        }
        
        if ( $this->disablePort2 == "0" || $this->disablePort2 = false){
            $this->disablePort2 = false;
        } else {
            $this->disablePort2 = true;
        }
        
        return parent::beforeValidate();        
    }

	function save($runValidation=true, $attributes=null ) {  
                
        if( $runValidation && !$this->validate($attributes)){
            return false;
        }
		if ( !$this->saveTemp() ){
            return false;
        }
        if (!$this->savePorts() ){
            return false;
        }        
        return true;            
	}
}
