<?php

require_once 'protected/utils/PullMode.php';

class USBStorage extends CModel {
	
	var $size;
    var $device_node;
    var $sysfs_device_path;
    var $writable=null;
    private $_usages = array();
    private $_user_available = false;
    
    var $message;
    
    var $forceFormat=false;
    var $forceUnmount=false;
    
	protected $format_id="";
	protected $format_pid="";

    static $usedForName = array(    '/srv/raperca/content'=>'Local Storage', 
                                    '/srv/raperca/capture'=>'Streaming Captures', 
                                    '/var/lib/updater/mnt-usb-updates'=>'Updates');
    static $userPathPrefix = "/srv/raperca/";
    
                                
    public function attributeLabels()
	{
		return array(
            'size'=>'Storage size',
            'usedFor'=>'Used as',
            'writable'=>'Writable',
     	);
	}
    
    public function attributeNames() {
        return array("size, path, usedFor, writable, mountedkey");
    }
    public function rules() {
		$res = array(
            array( "device_node, sysfs_device_path, forceFormat, forceUnmount", "safe"),
    	);
        return $res;
	}
    
    public function getSizeMBytes() {
        return floor($this->size/2048);
    }
    public function updateMountLocation(){
        $mount=file_get_contents("/proc/mounts");
        $mounts=explode("\n",$mount);
        foreach ($mounts as $mount){
            $info=preg_split("/\s/",$mount);            
            if ( $this->device_node==$info[0] ){                
                $this->addMountLocation($info[1], $info[3]);
            }            
        }
    }
    public function addMountLocation($path, $mopts) {
        if (isset(self::$usedForName[$path])) {
            $this->_usages[] = self::$usedForName[$path];
            if (strncmp($path, self::$userPathPrefix,
                        strlen(self::$userPathPrefix)) == 0)
                $this->_user_available = true;
        }        
        # parse mount options to determine if rw or ro
        $opts = explode(',', $mopts);
        $this->writable = "1"; # abscence of option means rw
        foreach ($opts as $opt) {
            if ($opt == "rw")
                $this->writable = "1";
            elseif ($opt == "ro")
                $this->writable = "0";
        }
    }

    public function getUsedFor() {
        if (empty($this->_usages))
            return 'Not currently in use';
        return join(", ", $this->_usages);
    }
    public function isUsed() {
        return ! empty($this->_usages);
    }
    function isFusionContent() {
        $idx = $this->getIndex();
        if ( file_exists( "/media/usb$idx/.spx-mount" ) ){            
            return file_exists( "/media/usb$idx/content/.fusion_enabled");
        } else {
            return file_exists( "/media/usb$idx/.fusion_enabled");
        }
    }
    public function isUserAvailable() {        
        return $this->_user_available;
    }
    public function getIndex() {
		return substr( $this->sysfs_device_path, -1 );
	}
    public function getWritableStr() {
        return $this->writable?"yes":"no";
    }
	public function getFormatID() {
		return $this->format_id;
	}
	public function getFormatPID() {
		return $this->format_pid;
	}
	public function getErrorStr() {
		return $this->final_string;
	}
    public function formatStart() {
		$dest = $this->sysfs_device_path;
		$opts = "";
		$forced=$this->forceFormat;
		if ($forced) $opts = "-f";
		do {
			$this->format_id = uniqid();
			$format_log = "/var/tmp/content-format-" . $this->format_id . ".log";
            
			$format_log_file = fopen($format_log, 'xb');
		} while ($format_log_file === FALSE);
		fclose($format_log_file);
		$this->format_pid = exec("nohup /usr/libexec/spxmanage/content-format $opts " . escapeshellarg($dest) . " </dev/null > /dev/null 2> " . escapeshellarg($format_log) . " & echo $!", $format_out, $format_ret);
        
        $this->message = "Formating in progress"; 
	}
	public function formatLogs( $format_id="") {
		$formatMsg=array(
			0 => "<h5>"."Format Success."."</h5>"."Unplug and replug the formatted USB storage device for the change to take effect. Alternatively you may restart the system for the change to take effect.", 
			1 => "USB storage not formated. Please reload the page and try again.", 
			2 => "USB storage is read only.", 
			3 => "USB storage ".($this->forceFormat?"is":"may be")." being accessed.",
			4 => "USB storage timeout waiting for other process to release writting lock.",
			8 => "USB storage format failed; filesystem is corrupted.",
			9 => "USB storage format failed; filesystem is corrupted.");
			
		if ( $format_id!="" )
			$this->format_id = $format_id;
		$format_log = "/var/tmp/content-format-" . $this->format_id . ".log";
		if ( file_exists( $format_log ) ) {
			$cnt = file_get_contents( $format_log );			
		} else {
			$cnt=1;
		}
        if ( preg_match("@EXIT: (\d)@", $cnt, $matches) ){
            $ret = intval($matches[1]);
            
            if ( $ret!=0 ){
                $this->addError( "", $formatMsg[$ret] );
            } else {
                $this->message = $formatMsg[ $ret ];
            }
            if ( $ret==3 ) {
                $this->forceFormat = true;
            }
            unlink( $format_log );
        } 
		if ( $cnt==1 ) {
            return false;
        }
		return $cnt;
		
	}
	
	public function formatOver( $format_pid="") {
		if ( $format_pid!="" )
			$this->format_pid = $format_pid;
		
		if ( PHP_OS == "WINNT" ) 
            return true;
            
        return !posix_kill($this->format_pid, 0);        
	}
	
    public function unmount() {
        
        $unmountMsg=array(
                0 => "USB storage device can now be safelly removed", 
                1 => "USB storage device not disconnected", 
                2 => "USB storage device is being accessed", 
                3 => "USB storage device can now be safelly removed");
        
        
        $dest = $this->device_node;
        $this->message ="";
        $opts = "";
        if ( $this->forceUnmount ) $opts = "-f";
        exec("/usr/libexec/spxmanage/usb-remove $opts " . escapeshellarg($dest), $out, $ret);
        
        foreach ($out as $str) {
            $this->message .= $str . "<br/>";
        }
        
        if ( $ret==0 || $ret==3) {
            $this->message .= $unmountMsg[$ret]."<br/>\n";
            $this->_usages = array();
            $this->_user_available = false;
        } elseif ( $ret==2) {
            $this->message .= $unmountMsg[$ret]."<br/>\n";
        } else {
            $this->addError( "", $unmountMsg[$ret] );
        }
        $this->message .= "</div>\n";
        if ($ret==2){
            $this->forceUnmount = true;
        }
        
    }
    function getContentUri(  ) {
        $idx = $this->getIndex();
        if ( file_exists( "/media/usb$idx/.spx-mount" ) ){            
            return "/media/usb$idx/content/";
        } else
            return "/media/usb$idx/";
    
    }
    function copyFromUsb( ) {
        $pull = new PullMode();
        
        $id = $pull->createEvent( "publish", $this->getContentUri( ), 10,
            array(
                "-preview"
            )
        );
        
        return $id;
    }
    function copyToUsb( ) {
        $pull = new PullMode();
        $id = $pull->createEvent( "publish", "/srv/.shadow-raperca/content/", 10,
            array(
                "-preview"
            )
        );
        return $id;
    } 
    function copyStatus( $id ) {
        $pullMode = new PullMode();
        $status = $pullMode->getStatus( $id );
        if ( $status['state'] == 'notfound' ){
            $this->addError('', "Publish ID not found" );
        } else if ( $status['state'] == 'finished' && $status['success'] != 1 ){
            foreach ( $status['errors'] as $error ){
                $this->addError('', $error['description'] );
            }            
        }
        return $status;
    }
}
