<?php
/* @var $this ConfigController */

ob_start(); 
$nameConfig = $this->beginWidget('SimpleForm', array( 
        'nbBox' => null,
        'labelSize' => 12,
        'inputSize' => 12,
        'formClass' => ""
) );
    echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO,
        "Enter a friendly name to identify this certificate for management purposes."
    );
    echo $nameConfig->activeTextField( $serverCertificates, "uid", array('data-validate' => "validateCertificateName", "data-placement" => "left" )  );
$this->endWidget();
$nameStep = ob_get_contents ( );
ob_end_clean();

ob_start(); 
$serverCertificatesConfig = $this->beginWidget('SimpleForm', array( 
        'nbBox' => null,
        'labelSize' => 12,
        'inputSize' => 12,
        'formClass' => ""
) );

    echo $serverCertificatesConfig->activeDropDownList( $serverCertificates, "type", 
        $serverCertificates->typeValues, array( ), true
    );
    
    echo CHtml::openTag("div", array( 'data-bind' => "visible: type() == 'pfx'") );    
        echo $serverCertificatesConfig->activeFileField( $serverCertificates, "pfxFile");
    echo CHtml::closeTag("div") ."\n";
    
    echo CHtml::openTag("div", array( 'data-bind' => "visible: type() == 'pem'") );    
        echo $serverCertificatesConfig->activeFileField( $serverCertificates, "certificateFile");
        echo $serverCertificatesConfig->activeFileField( $serverCertificates, "keyFile"  );
        echo $serverCertificatesConfig->activeFileField( $serverCertificates, "chainFile"  );
    echo CHtml::closeTag("div") ."\n";
        
$this->endWidget();
$newServerCertificateStep = ob_get_contents ( );
ob_end_clean();

ob_start(); 
$passphraseConfig = $this->beginWidget('SimpleForm', array( 
        'nbBox' => null,
        'labelSize' => 12,
        'inputSize' => 12,
        'formClass' => ""
) );
    echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO,
        "If the certificate key is encrypted you should provide the passphrase."
    );    
    echo $passphraseConfig->activeTextField( $serverCertificates, "passphrase"  );
$this->endWidget();
$passphraseStep = ob_get_contents ( );
ob_end_clean();


$this->widget('SPXWizard', array(
    'wizardName' => 'yiiAddServerCertificates',
    'title' => "Server Certificate",    
    'pages' => array(        
        array(  'title'=> 'Name', 
                'content'=> $nameStep
        ), 
        array(  'title'=> 'Certificate', 
                'content'=> $newServerCertificateStep
        ),    
    array(  'title'=> 'Passphrase', 
                'content'=> $passphraseStep
        ),          
    ),    
    'failure' => "An error occurred when submitting the configuration. Please reload the page and start setup again.",
    'options' => array(
        'formClass' => 'xxx',
        'enctype' => 'multipart/form-data',
        'show' => false,
        'contentHeight' => 380,
        'contentWidth' => 650
    ), 
//    'submit'=> "",    
    'ajax' => array(
        "type" => "POST",
        "url" => CHtml::normalizeUrl( array( 'certificates/addServer' ) ),            
        "dataType" => "json",
        "successFunction" => "addCertificateSucess",
        "failFunction" => "addCertificateFail"
    )
         
) );

$serverCertificatesConfig = $this->beginWidget('SimpleForm', array( 
    'title' => "Server Certificates",
    'id' => "ServerCertificates",
    //'button' => "Apply",    
    //'action' => array ( 'post' => array( 'enctype' => 'multipart/form-data' ) )
) );
    echo BsHtml::alert( BsHtml::ALERT_COLOR_INFO,
            "These are the certificates for the embedded web server. The active certificate is curently in use to autenticate all HTTPS access to the player."
    );
    $serverCertificatesConfig->errorSummary( $serverCertificates );
    $headers = array(
        "Name", 
        "Server Name(s)",
        "Valid until",
        "Info", 
        "Active",        
        "Remove",   
    );
    $options = array(
        "data-bind" => "foreach: serverCertificatesList",
        "sizes" => array( "col-sm-2", "col-sm-3", "col-sm-2", "col-sm-1", "col-sm-1", "col-sm-1" )
    );
    $row = array();
    $row[] = CHtml::tag( "span", array(
        "data-bind" => "text: uid"
    ), "");
    $row[] = CHtml::tag( "span", array(
        "data-bind" => "text: allNames.join(', ')"
    ), "");
    $row[] = CHtml::tag( "span", array(
        "data-bind" => "text: validTo "
    ), "");
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-info "), "" ), array( 'certificates/view' ), array(
        "data-bind" => "click: \$parent.doViewServerCertificate",        
        "class" => "btn btn-sm btn-default btn-block"
    ) );
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-circle-o "), "" ), array( 'certificates/activate' ), array(
            "data-bind" => "visible: !activeCertificates, click: \$parent.doActivateServerCertificate",        
            "class" => "btn btn-sm btn-default btn-block"
        ) ) .CHtml::link( CHtml::tag("i", array( "class" => "fa fa-check-circle-o"), "" ), array( 'certificates/activate' ), array(
            "data-bind" => "visible: activeCertificates, click: \$parent.doActivateServerCertificate",        
            "class" => "btn btn-sm btn-default btn-block"
        ) );
    /*
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-download"), "" ), array( 'fsmView' ), array(
            "data-bind" => "attr: { href: '".CHtml::normalizeUrl(array( 'certificates/view' ))."/target/' + encodeURIComponent( filename ) }",
            "class" => "btn btn-sm btn-default btn-block"
        ) );
     */
    $row[] = CHtml::link( CHtml::tag("i", array( "class" => "fa fa-times"), "" ), array( 'certificates/deleteServer' ), array(
        "data-bind" => "visible: uploaded && !activeCertificates, click: \$parent.doRemoveServerCertificate",
        "class" => "btn btn-sm btn-warning btn-block"
    ) );
   
    $this->widget('BsRow', array( 
        'options' => array( 'data-bind' => 'visible: serverCertificatesList().length > 0', 'class' => 'table-responsive'),
        'content' => $serverCertificatesConfig->table( $headers, array( $row ), $options ) 
    ));
    
    echo "<br/>";
    
    $this->widget( 'DialogButton' , array(
        'label' => "Add Server Certificate",
        'script' => "yiiAddServerCertificates.show();",
        'content' => false
    ));
    
$this->endWidget();

$certificatesList = $serverCertificates->getCertificatesList( );
?>
<script type="text/javascript" >
//<![CDATA[
yiiModel.serverCertificatesList = ko.observableArray( <?php
    echo CJavaScript::encode( $certificatesList );
?> );

yiiModel.doRemoveServerCertificate = function( model, ev ) {
    var item = this;
    var btn = $(ev.currentTarget);
    var opt = {
        url: btn.attr("href"),
        data: { uid : item.uid },
        type: 'POST'
    };
    yiiModel.doAjax( yiiModel, ev, opt, function( ev, response ) {
        yiiModel.serverCertificatesList( response.data ); 
    });
};
yiiModel.doActivateServerCertificate = function( model, ev ) {
    var item = this;
    var btn = $(ev.currentTarget);
    btn.button('loading');
    var opt = {
        url: btn.attr("href"),
        data: { uid : item.uid },
        type: 'POST'
    };
    yiiModel.doAjax( yiiModel, ev, opt, function( ev, response ) {
        yiiModel.serverCertificatesList( response.data ); 
    });
};
var actionIdx = 0;
function createPanel( idx, name, txt, height ){
    var     panel = $("<div/>").addClass("panel panel-default"),
            header = $("<div/>").addClass("panel-heading")
                                .appendTo(panel),
            headerTitle = $("<h4/>").addClass("panel-title")
                                .appendTo(header),
            headerLink = $("<a/>").addClass("collapsed")
                                .attr({ "data-toggle": "collapse", "data-parent": "#BundleAccordion" + actionIdx, "href": "#BundleCollapse" +actionIdx +idx })
                                .text( name ).appendTo(headerTitle),
            colapse = $("<div/>").addClass("panel-collapse collapse")
                                .attr("id", "BundleCollapse" + actionIdx + idx)
                                .appendTo(panel),
            body = $("<pre/>").addClass("panel-body").height(height)
                                .text( txt )
                                .appendTo(colapse);
    if ( idx === "Cert" ){
        colapse.addClass("in");
    }
    return panel;
}
yiiModel.doViewServerCertificate = function( model, ev ) {
    var item = this;
    var btn = $(ev.currentTarget);
    /*
     CHtml::link( CHtml::tag("i", array( "class" => "fa fa-download"), "" ), array( 'certificates/viewServer' ), array(
                        "data-bind" => "attr: { href: '".CHtml::normalizeUrl(array( 'certificates/viewServer' ))."/target/' + encodeURIComponent( viewServerCertificate().uid ) }",
                        "class" => "btn btn-sm btn-default btn-block"
                    ) )
         */
    var height = $(window).height() * 0.6;
    var body;
    if ( item.bundle && item.bundle.length && item.bundle.length > 0 ){
       actionIdx ++;
       body = $("<div/>").addClass("panel-group").attr("id", "BundleAccordion" + actionIdx),
       createPanel( "Cert", "Server certificate", item.text, height ).appendTo(body);
       for ( var i=0; i<item.bundle.length; i++ ){
           createPanel( i, "Chain certificate #"+(i+1), item.bundle[i], height ).appendTo(body);
       }
    } else {
       body = $("<pre/>").height(height).text( item.text ); 
    }
    spxapi.ui.modalDialog({
        contentHeight: '100%',
        contentWidth: 650,
        title: item.uid,
        body: body,
        buttons: [
            { name: "Download Certificate", 
              action: function() { console.log("clicked"); window.location = "<?php echo CHtml::normalizeUrl(array( "certificates/viewServer" )) ?>/target/" + item.uid; },
              close: false
            }
        ]
    });
};
function validateCertificateName( el ) {
    var name = el.val();
    var retValue = {};

    var nameRE = /^[0-9a-zA-Z_.@]{4,32}$/;
    if ( !nameRE.test(name) ){
        retValue.status = false;
        retValue.msg = "Name must be between 4 and 32 characters and contains only number, letter and any of the following .@_";
    } else {        
        retValue.status = true;
    }

    return retValue;
}

function addCertificateSucess ( response ) {
    yiiModel.serverCertificatesList( response.data );
    yiiModel.updatePlayerResponse( response );
    // clear the form
    $("#ServerCertificates_uid").val("");
    $("#ServerCertificates_passphrase").val("");
    yiiModel.keyFile("");
    yiiModel.certificateFile("");
    yiiModel.chainFile("");
    yiiModel.pfxFile("");
    
};
function addCertificateFail( jqXHR, textStatus, errorThrown ){
    //console.log(errorThrown);
    yiiModel.addErrors( [ errorThrown] );
}
//]]></script>