<?php
include_once 'protected/utils/MaintenanceJobs.php';

class Maintenance extends CFormModel {
	
    static $report="/usr/sbin/spxreport";
    var $jobs;
	
    public function init() {
        parent::init();
        $this->jobs = new MaintenanceJobs;
    }
    public function rules() {
		$res = array(
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'title'=>'Network Credentials',
    	);
	}
    
    function getReportFile( $ext=false) {
	
		// create an XML backup of the config first
		$backup = new ConfigBackup;
		$backup->backupPassword = false;
		$fn = file_exists("/var/cache/spxmanage") ?
            '/var/cache/spxmanage/spxbackup.xml' : '/var/cache/raperca/spxbackup.xml';
        file_put_contents($fn, $backup->create() );
		
        $serial=Yii::app()->device->serial;
        return $this->jobs->getReportFile( $serial, $ext );
    }
    
    function forcedReboot( $recovery=false ) {
        if ( $recovery ) {
            Tools::addReason("diagnostic mode restart");
        } else {
            Tools::addReason("restart");
        }
        Tools::shutdown( true, $recovery );
    }
	function shutdown( ) {
        Tools::addReason("power-off");
        Tools::shutdown( true, false, false, true );
    }
    
    function checkSSH () {
		return $this->jobs->checkSSH ();
    }
    
    function manageSSH( $start=true ) {
		return $this->jobs->manageSSH( $start );
    }
    function resetFactory( ) {
        $this->jobs->resetFactory( );
        Tools::addReason("reset to factory default");
        Tools::$redirect = "/";
        Tools::shutdown( true );
    }
    function formatStorage( ) {
        
        $this->jobs->formatStorage( );
        Tools::addReason("format internal storage");
        Tools::$redirect = "/";
        Tools::shutdown( true );
    }

    function resetPublishedContent( ) {
        
        $this->jobs->resetContent( );        
        exec('sync'); // make sure the clean-cache file is on stable storage

    }

    function clearWebstorage( ) {
        $this->jobs->clearWebstorage(); 
    }
    function resetContent( ) {
        
        $this->jobs->resetContent( );
        $this->jobs->clearInterfaceContent( );
        $this->jobs->clearWebstorage();  
        exec('sync'); // make sure the clean-cache file is on stable storage
        
        Tools::addReason("reset content to default");
    }
    
    function clearLogs( ) {
		$this->jobs->clearLogs( );
    }
    function clearCache( ) {
        if ($this->jobs->clearCache( )) {
            Tools::addReason("clearing player cache"); // cache cleanup will be finalized on restart
        } else {
            $this->addError("","Failed creating cache cleanup job");
        }
    }
    function clearNtp( ) {
        if ( $this->jobs->clearNtp( ) ) {
            Tools::addReason("clearing clock calibration"); 
        } else {
            $this->addError("","Failed creating clock calibration clear job");
        }
    }
    function clearStreaming( ) {
        $this->jobs->clearStreaming( );
    }
    function clearWebPageData( ) {
        if ( $this->jobs->clearWebPageData( ) ) {
            Tools::addReason("clearing web page data"); 
        } else {
            $this->addError("","Failed creating web page data clear job");
        }
    }
}
